// OSERDESE2: Output SERial/DESerializer with bitslip
//            7 Series
// Xilinx HDL Libraries Guide, version 13.1

OSERDESE2 #(
   .DATA_RATE_OQ("DDR"),   // "SDR" or "DDR"
   .DATA_RATE_TQ("DDR"),   // "BUF", "SDR" or "DDR"
   .DATA_WIDTH(4),         // Parallel data width (2-8,10)
   .INIT_OQ(1'b0),         // Initial value of OQ output (0/1)
   .INIT_TQ(1'b0),         // Initial value of TQ output (0/1)
   .SERDES_MODE("MASTER"), // "MASTER" or "SLAVE"
   .SRVAL_OQ(1'b0),        // OQ output value when SR is used (0/1)
   .SRVAL_TQ(1'b0),        // TQ output value when SR is used (0/1)
   .TBYTE_CTL("FALSE"),    // Enable tristate byte operation ("TRUE" or "FALSE")
   .TBYTE_SRC("FALSE"),    // Tristate byte source ("TRUE" or "FALSE")
   .TRISTATE_WIDTH(4)      // 3-state converter width (1 or 4)
)
OSERDESE2_inst (
   .OFB(OFB),             // 1-bit output: Feedback path for data output
   .OQ(OQ),               // 1-bit output: Data path output
   // SHIFTOUT1/SHIFTOUT2: 1-bit (each) output: Data output expansion (1-bit each)
   .SHIFTOUT1(SHIFTOUT1),
   .SHIFTOUT2(SHIFTOUT2),
   .TBYTEOUT(TBYTEOUT),   // 1-bit output: Byte group tristate output
   .TFB(TFB),             // 1-bit output: 3-state control output
   .TQ(TQ),               // 1-bit output: 3-state control output
   .CLK(CLK),             // 1-bit input: High speed clock input
   .CLKDIV(CLKDIV),       // 1-bit input: Divided clock input
   // D1 - D8: 1-bit (each) input: Parallel data inputs (1-bit each)
   .D1(D1),
   .D2(D2),
   .D3(D3),
   .D4(D4),
   .D5(D5),
   .D6(D6),
   .D7(D7),
   .D8(D8),
   .OCE(OCE),             // 1-bit input: Output data clock enable input
   .RST(RST),             // 1-bit input: Reset input
   // SHIFTIN1/SHIFTIN2: 1-bit (each) input: Data input expansion (1-bit each)
   .SHIFTIN1(SHIFTIN1),
   .SHIFTIN2(SHIFTIN2),
   // T1 - T4: 1-bit (each) input: Parallel 3-state inputs
   .T1(T1),
   .T2(T2),
   .T3(T3),
   .T4(T4),
   .TBYTEIN(TBYTEIN),     // 1-bit input: Byte group tristate input
   .TCE(TCE)              // 1-bit input: 3-state clock enable input
);

// End of OSERDESE2_inst instantiation
