// PLLE2_ADV: Phase Locked Loop
//            7 Series
// Xilinx HDL Libraries Guide, version 13.1

PLLE2_ADV #(
   .BANDWIDTH("OPTIMIZED"),  // "OPTIMIZED", "HIGH",or "LOW"
   .CLKFBOUT_MULT(5),        // Multiply value for all CLKOUT (2-64)
   .CLKFBOUT_PHASE(0.0),     // Phase offset in degrees of CLKFB (-360.00-360.00).
   // CLKIN_PERIOD: Input clock period in nS to ps resolution (i.e. 33.333 is 30 MHz).
   .CLKIN1_PERIOD(0.0),
   .CLKIN2_PERIOD(0.0),
   // CLKOUT0_DIVIDE - CLKOUT5_DIVIDE: Divide amount for CLKOUT (1-128)
   .CLKOUT0_DIVIDE(1),
   .CLKOUT1_DIVIDE(1),
   .CLKOUT2_DIVIDE(1),
   .CLKOUT3_DIVIDE(1),
   .CLKOUT4_DIVIDE(1),
   .CLKOUT5_DIVIDE(1),
   // CLKOUT0_DUTY_CYCLE - CLKOUT5_DUTY_CYCLE: Duty cycle for CLKOUT outputs (0.001-0.999).
   .CLKOUT0_DUTY_CYCLE(0.5),
   .CLKOUT1_DUTY_CYCLE(0.5),
   .CLKOUT2_DUTY_CYCLE(0.5),
   .CLKOUT3_DUTY_CYCLE(0.5),
   .CLKOUT4_DUTY_CYCLE(0.5),
   .CLKOUT5_DUTY_CYCLE(0.5),
   // CLKOUT0_PHASE - CLKOUT5_PHASE: Phase offset for CLKOUT outputs (-360.000-360.000).
   .CLKOUT0_PHASE(0.0),
   .CLKOUT1_PHASE(0.0),
   .CLKOUT2_PHASE(0.0),
   .CLKOUT3_PHASE(0.0),
   .CLKOUT4_PHASE(0.0),
   .CLKOUT5_PHASE(0.0),
   .COMPENSATION("ZHOLD"),   // "ZHOLD", "INTERNAL", "EXTERNAL" or "BUF_IN"
   .DIVCLK_DIVIDE(1),        // Master division value (1-56)
   // REF_JITTER: Reference input jitter in UI (0.000-0.999).
   .REF_JITTER1(0.0),
   .REF_JITTER2(0.0),
   .STARTUP_WAIT("FALSE")    // Delay DONE until PLL Locks, "TRUE"/"FALSE"
)
PLLE2_ADV_inst (
   // Clock Outputs: 1-bit (each) output: User configurable clock outputs
   .CLKOUT0(CLKOUT0),   // 1-bit output: CLKOUT0 output
   .CLKOUT1(CLKOUT1),   // 1-bit output: CLKOUT1 output
   .CLKOUT2(CLKOUT2),   // 1-bit output: CLKOUT2 output
   .CLKOUT3(CLKOUT3),   // 1-bit output: CLKOUT3 output
   .CLKOUT4(CLKOUT4),   // 1-bit output: CLKOUT4 output
   .CLKOUT5(CLKOUT5),   // 1-bit output: CLKOUT5 output
   // DRP Ports: 16-bit (each) output: Dynamic reconfigration ports
   .DO(DO),             // 16-bit output: DRP data output
   .DRDY(DRDY),         // 1-bit output: DRP ready output
   // Feedback Clocks: 1-bit (each) output: Clock feedback ports
   .CLKFBOUT(CLKFBOUT), // 1-bit output: Feedback clock output
   // Status Ports: 1-bit (each) output: PLL status ports
   .LOCKED(LOCKED),     // 1-bit output: LOCK output
   // Clock Inputs: 1-bit (each) input: Clock inputs
   .CLKIN1(CLKIN1),     // 1-bit input: Primary clock input
   .CLKIN2(CLKIN2),     // 1-bit input: Secondary clock input
   // Control Ports: 1-bit (each) input: PLL control ports
   .CLKINSEL(CLKINSEL), // 1-bit input: Clock select input
   .PWRDWN(PWRDWN),     // 1-bit input: Power-down input
   .RST(RST),           // 1-bit input: Reset input
   // DRP Ports: 7-bit (each) input: Dynamic reconfigration ports
   .DADDR(DADDR),       // 7-bit input: DRP adrress input
   .DCLK(DCLK),         // 1-bit input: DRP clock input
   .DEN(DEN),           // 1-bit input: DRP enable input
   .DI(DI),             // 16-bit input: DRP data input
   .DWE(DWE),           // 1-bit input: DRP write enable input
   // Feedback Clocks: 1-bit (each) input: Clock feedback ports
   .CLKFBIN(CLKFBIN)    // 1-bit input: Feedback clock input
);

// End of PLLE2_ADV_inst instantiation
