// XADC: Xilinx Analog-to-Digital Converter
//       7 Series
// Xilinx HDL Libraries Guide, version 13.1

XADC #(
   // INIT_40 - INIT_42: XADC configuration registers
   .INIT_40(16'h0000),
   .INIT_41(16'h0000),
   .INIT_42(16'h0800),
   // INIT_43 - INIT_47: XADC Test registers (do not edit)
   .INIT_43(16'h0000),
   .INIT_44(16'h0000),
   .INIT_45(16'h0000),
   .INIT_46(16'h0000),
   .INIT_47(16'h0000),
   // INIT_48 - INIT_4F: Sequence registers for the Channel Sequencer
   .INIT_48(16'h0000),
   .INIT_49(16'h0000),
   .INIT_4A(16'h0000),
   .INIT_4B(16'h0000),
   .INIT_4C(16'h0000),
   .INIT_4D(16'h0000),
   .INIT_4F(16'h0000),
   .INIT_4E(16'h0000),              // Sequence register 6
   // INIT_50 - INIT_58, INIT5C: Alarm threshold registers
   .INIT_50(16'h0000),
   .INIT_51(16'h0000),
   .INIT_52(16'h0000),
   .INIT_53(16'h0000),
   .INIT_54(16'h0000),
   .INIT_55(16'h0000),
   .INIT_56(16'h0000),
   .INIT_57(16'h0000),
   .INIT_58(16'h0000),
   .INIT_5C(16'h0000),
   // Reserved: Reserved for future use
   .INIT_59(16'h0000),
   .INIT_5A(16'h0000),
   .INIT_5B(16'h0000),
   .INIT_5D(16'h0000),
   .INIT_5E(16'h0000),
   .INIT_5F(16'h0000),
   // Simulation attributes: Set for proepr simulation behavior
   .SIM_MONITOR_FILE("design.txt")  // Analog simulation data file name
)
XADC_inst (
   // Alarm Ports: 8-bit (each) output: ALM, OT
   .ALM(ALM),                   // 8-bit output: Output alarm for temp, Vccint and Vccaux
   .OT(OT),                     // 1-bit output: Over-Temperature alarm output
   // DRP Ports: 16-bit (each) output: Dynamic Reconfiguration Ports
   .DO(DO),                     // 16-bit output: DRP output data bus
   .DRDY(DRDY),                 // 1-bit output: DRP data ready output signal
   // Status Ports: 1-bit (each) output: XADC status ports
   .BUSY(BUSY),                 // 1-bit output: ADC busy output
   .CHANNEL(CHANNEL),           // 5-bit output: Channel selection outputs
   .EOC(EOC),                   // 1-bit output: End of Conversion output
   .EOS(EOS),                   // 1-bit output: End of Sequence output
   .JTAGBUSY(JTAGBUSY),         // 1-bit output: JTAG DRP transaction in progress output
   .JTAGLOCKED(JTAGLOCKED),     // 1-bit output: JTAG requested DRP port lock output
   .JTAGMODIFIED(JTAGMODIFIED), // 1-bit output: JTAG Write to the DRP has occurred output
   .MUXADDR(MUXADDR),           // 5-bit output: External MUX channel decode output
   // Auxiliary Analog-Input Pairs: 16-bit (each) input: VAUXP[15:0], VAUXN[15:0]
   .VAUXN(VAUXN),               // 16-bit input: N-side auxiliary analog input
   .VAUXP(VAUXP),               // 16-bit input: P-side auxiliary analog input
   // Control and Clock Ports: 1-bit (each) input: Reset, conversion start and clock inputs
   .CONVST(CONVST),             // 1-bit input: Convert start input
   .CONVSTCLK(CONVSTCLK),       // 1-bit input: Convert start input
   .RESET(RESET),               // 1-bit input: Active-high reset input
   // DRP Ports: 7-bit (each) input: Dynamic Reconfiguration Ports
   .DADDR(DADDR),               // 7-bit input: DRP input address bus
   .DCLK(DCLK),                 // 1-bit input: DRP clock input
   .DEN(DEN),                   // 1-bit input: DRP input enable signal
   .DI(DI),                     // 16-bit input: DRP input data bus
   .DWE(DWE),                   // 1-bit input: DRP write enable input
   // Dedicated Analog Input Pair: 1-bit (each) input: VP/VN
   .VN(VN),                     // 1-bit input: N-side analog input
   .VP(VP)                      // 1-bit input: P-side analog input
);

// End of XADC_inst instantiation
