----------------------------------------------------------------------------------
-- Company: Xilinx, Inc.
-- Engineer: Eddie Vergara
-- 
-- Create Date:    08:38:05 03/16/2009 
-- Design Name:    DRP Demo - DCM
-- Module Name:    drp_stmach - Behavioral 
-- Project Name:   DRP Demo
-- Target Devices: xc5vlx30
-- Tool versions:  11.1
-- Description:    This module contains an instantiation of a Virtex-5 DCM (DCM_ADV) 
--		   allowing access to the DCM input clock (CLKIN_IN), reset port (RST_IN),
--                 output of the Digital Frequency Synthesizer (CLKFX_OUT), as well as 
--                 the Dynamic Reconfiguration Ports.
--
--		   For more information about the Virtex-5 DCM, refer to section "Clock 
--		   Management Technology" in the Virtex-5 User Guide (UG190).
--
--		   http://www.xilinx.com/support/documentation/virtex-5.htm
--
----------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity drp_dcm is
   port ( CLKIN_IN   : in    std_logic; 
          DADDR_IN   : in    std_logic_vector (6 downto 0); 
          DCLK_IN    : in    std_logic; 
          DEN_IN     : in    std_logic; 
          DI_IN      : in    std_logic_vector (15 downto 0); 
          DWE_IN     : in    std_logic; 
          RST_IN     : in    std_logic; 
          CLKFX_OUT  : out   std_logic; 
          CLK0_OUT   : out   std_logic; 
          DRDY_OUT   : out   std_logic; 
          LOCKED_OUT : out   std_logic);
end drp_dcm;

architecture BEHAVIORAL of drp_dcm is
   signal CLKFB_IN   : std_logic;
   signal CLKFX_BUF  : std_logic;
   signal CLK0_BUF   : std_logic;
   signal GND_BIT    : std_logic;
begin
   GND_BIT <= '0';
   CLK0_OUT <= CLKFB_IN;
   CLKFX_BUFG_INST : BUFG
      port map (I=>CLKFX_BUF,
                O=>CLKFX_OUT);
   
   CLK0_BUFG_INST : BUFG
      port map (I=>CLK0_BUF,
                O=>CLKFB_IN);
   
   DCM_ADV_INST : DCM_ADV
   generic map( CLK_FEEDBACK => "1X",
            CLKDV_DIVIDE => 2.0,
            CLKFX_DIVIDE => 2,
            CLKFX_MULTIPLY => 2,
            CLKIN_DIVIDE_BY_2 => FALSE,
            CLKIN_PERIOD => 10.000,
            CLKOUT_PHASE_SHIFT => "NONE",
            DCM_AUTOCALIBRATION => TRUE,
            DCM_PERFORMANCE_MODE => "MAX_SPEED",
            DESKEW_ADJUST => "SYSTEM_SYNCHRONOUS",
            DFS_FREQUENCY_MODE => "LOW",
            DLL_FREQUENCY_MODE => "LOW",
            DUTY_CYCLE_CORRECTION => TRUE,
            FACTORY_JF => x"F0F0",
            PHASE_SHIFT => 0,
            STARTUP_WAIT => FALSE,
            SIM_DEVICE => "VIRTEX5")
      port map (CLKFB=>CLKFB_IN,
                CLKIN=>CLKIN_IN,
                DADDR(6 downto 0)=>DADDR_IN(6 downto 0),
                DCLK=>DCLK_IN,
                DEN=>DEN_IN,
                DI(15 downto 0)=>DI_IN(15 downto 0),
                DWE=>DWE_IN,
                PSCLK=>GND_BIT,
                PSEN=>GND_BIT,
                PSINCDEC=>GND_BIT,
                RST=>RST_IN,
                CLKDV=>open,
                CLKFX=>CLKFX_BUF,
                CLKFX180=>open,
                CLK0=>CLK0_BUF,
                CLK2X=>open,
                CLK2X180=>open,
                CLK90=>open,
                CLK180=>open,
                CLK270=>open,
                DO=>open,
                DRDY=>DRDY_OUT,
                LOCKED=>LOCKED_OUT,
                PSDONE=>open);
   
end BEHAVIORAL;


