
 PARAMETER VERSION = 2.2.0


BEGIN OS
 PARAMETER OS_NAME = xilkernel
 PARAMETER OS_VER = 5.01.a
 PARAMETER PROC_INSTANCE = microblaze_0
# Specification of the intc device
 PARAMETER sysintc_spec = microblaze_0_intc
# Specifying the standard IN / OUT device
 PARAMETER STDIN = RS232_Uart_1
 PARAMETER STDOUT = RS232_Uart_1
# Enhanced features
 PARAMETER enhanced_features = true
 PARAMETER config_kill = true
# Enable diagnostic/debug messages
 PARAMETER config_debug_support = true
 PARAMETER verbose = true
# MSGQ's require config_bufmalloc to be true.
 PARAMETER config_bufmalloc = true
# Semaphore specification
 PARAMETER config_sema = true
 PARAMETER max_sem_waitq = 10
 PARAMETER max_sem = 4
# MSGQ specification
 PARAMETER config_msgq = true
 PARAMETER msgq_capacity = 10
 PARAMETER num_msgqs = 1
# Configure time related features
 PARAMETER config_time = true
 PARAMETER max_tmrs = 10
# Scheduling type
 PARAMETER config_sched = true
 PARAMETER max_readyq = 10
 PARAMETER n_prio = 6
 PARAMETER sched_type = SCHED_PRIO
# Configure pthreads
 PARAMETER config_pthread_support = true
 PARAMETER config_pthread_mutex = true
 PARAMETER max_pthreads = 10
# MicroBlaze system timer device specification
 PARAMETER systmr_spec = true
 PARAMETER systmr_interval = 100
 PARAMETER systmr_freq = 100000000
 PARAMETER systmr_dev = axi_timer_1
 PARAMETER mem_table = ((4,30),(8,20))
 PARAMETER static_pthread_table = ((shell_main,1))
END


BEGIN PROCESSOR
 PARAMETER DRIVER_NAME = cpu
 PARAMETER DRIVER_VER = 1.13.a
 PARAMETER HW_INSTANCE = microblaze_0
END


BEGIN DRIVER
 PARAMETER DRIVER_NAME = v6_ddrx
 PARAMETER DRIVER_VER = 2.00.a
 PARAMETER HW_INSTANCE = DDR3_SDRAM
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = uartlite
 PARAMETER DRIVER_VER = 2.00.a
 PARAMETER HW_INSTANCE = RS232_Uart_1
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = tmrctr
 PARAMETER DRIVER_VER = 2.03.a
 PARAMETER HW_INSTANCE = axi_timer_0
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = tmrctr
 PARAMETER DRIVER_VER = 2.03.a
 PARAMETER HW_INSTANCE = axi_timer_1
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = uartlite
 PARAMETER DRIVER_VER = 2.00.a
 PARAMETER HW_INSTANCE = debug_module
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = bram
 PARAMETER DRIVER_VER = 3.00.a
 PARAMETER HW_INSTANCE = microblaze_0_d_bram_ctrl
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = bram
 PARAMETER DRIVER_VER = 3.00.a
 PARAMETER HW_INSTANCE = microblaze_0_i_bram_ctrl
END

BEGIN DRIVER
 PARAMETER DRIVER_NAME = intc
 PARAMETER DRIVER_VER = 2.02.a
 PARAMETER HW_INSTANCE = microblaze_0_intc
END


