-- IOBUFDS_DIFF_OUT_INTERMDISABLE:  Differential Global Clock Buffer with Differential Output
--                                  Input Termination and Input Path Disable
--                                  May only be placed in High Range (HR) Banks
--                                  7 Series
-- Xilinx HDL Libraries Guide, version 13.3

IOBUFDS_DIFF_OUT_INTERMDISABLE_inst : IOBUFDS_DIFF_OUT_INTERMDISABLE
generic map (
   DIFF_TERM => "FALSE", -- Differential Termination (TRUE/FALSE)
   IBUF_LOW_PWR => "TRUE", -- Low Power - TRUE, High Performance = FALSE
   IOSTANDARD => "BLVDS_25", -- Specify the I/O standard
   USE_IBUFDISABLE => "TRUE") -- Use IBUFDISABLE function, "TRUE" or "FALSE"
port map (
   O => O,     -- Buffer p-side output
   OB => OB,   -- Buffer n-side output
   IO => IO,   -- Diff_p inout (connect directly to top-level port)
   IOB => IOB, -- Diff_n inout (connect directly to top-level port)
   DCITERMDISABLE => DCITERMDISABLE, -- DCI Termination enable input
   I => I,     -- Buffer input
   IBUFDISABLE => IBUFDISABLE, -- input disable input, low=disable
   INTERMDISABLE => INTERMDISABLE, -- Input termination disable input 
   TM => TM,   -- 3-state enable input, high=input, low=output
   TS => TS    -- 3-state enable input, high=output, low=input
);
  
-- End of IOBUFDS_DIFF_OUT_DCIEN_inst instantiation
