// IOBUFDS_DCIEN: Differential Bi-directional Buffer with Digital Controlled Impedance (DCI)
//                and Input path enable/disable
//                May only be placed in High Performance (HP) Banks
//                7 Series
// Xilinx HDL Libraries Guide, version 13.3

IOBUFDS_DCIEN #(
   .DIFF_TERM("FALSE"),     // Differential Termination ("TRUE"/"FALSE")
   .IBUF_LOW_PWR("TRUE"),   // Low Power - "TRUE", High Performance = "FALSE"
   .IOSTANDARD("BLVDS_25"), // Specify the I/O standard
   .SLEW("SLOW"),           // Specify the output slew rate
   .USE_IBUFDISABLE("TRUE") // Use IBUFDISABLE function, "TRUE" or "FALSE"
) IOBUFDS_DCIEN_inst (
   .O(O),     // Buffer output
   .IO(IO),   // Diff_p inout (connect directly to top-level port)
   .IOB(IOB), // Diff_n inout (connect directly to top-level port)
   .DCITERMDISABLE(DCITERMDISABLE), // DCI Termination enable input
   .I(I),                           // Buffer input
   .IBUFDISABLE(IBUFDISABLE),       // Input disable input, low=disable
   .T(T)      // 3-state enable input, high=input, low=output
);
  
// End of IOBUFDS_DCIEN_inst instantiation
