// IOBUFDS_DIFF_OUT_INTERMDISABLE: Differential Global Clock Buffer with Differential Output
//                                 Input Termination and Input Path Disable
//                                 May only be placed in High Range (HR) Banks
//                                 7 Series
// Xilinx HDL Libraries Guide, version 13.3

IOBUFDS_DIFF_OUT_INTERMDISABLE #(
   .DIFF_TERM("FALSE"),     // Differential Termination, "TRUE"/"FALSE"
   .IBUF_LOW_PWR("TRUE"),   // Low power="TRUE", Highest performance="FALSE"
   .IOSTANDARD("DEFAULT"),  // Specify the input I/O standard
   .USE_IBUFDISABLE("TRUE") // Set to "TRUE" to enable IBUFDISABLE feature
) IOBUFDS_DIFF_OUT_INTERMDISABLE_inst (
   .O(O),     // Buffer p-side output
   .OB(OB),   // Buffer n-side output
   .IO(IO),   // Diff_p inout (connect directly to top-level port)
   .IOB(IOB), // Diff_n inout (connect directly to top-level port)
   .I(I),     // Buffer input
   .INTERMDISABLE(INTERMDISABLE), //  Input termination disable input
   .IBUFDISABLE(IBUFDISABLE),     // Input disable input, low=disable
   .TM(TM),   // 3-state enable input, high=input, low=output
   .TS(TS)    // 3-state enable input, high=output, low=input
);

// End of IOBUFDS_DIFF_OUT_INTERMDISABLE_inst instantiation
