// ISERDESE1: Input SERial/DESerializer
//            Virtex-6
// Xilinx HDL Libraries Guide, version 13.2

ISERDESE1 #(
   .DATA_RATE("DDR"),           // "SDR" or "DDR"
   .DATA_WIDTH(4),              // Parallel data width (2-8, 10)
   .DYN_CLKDIV_INV_EN("FALSE"), // Enable DYNCLKDIVINVSEL inversion (TRUE/FALSE)
   .DYN_CLK_INV_EN("FALSE"),    // Enable DYNCLKINVSEL inversion (TRUE/FALSE)
   // INIT_Q1 - INIT_Q4: Initial value on the Q outputs (0/1)
   .INIT_Q1(1'b0),
   .INIT_Q2(1'b0),
   .INIT_Q3(1'b0),
   .INIT_Q4(1'b0),
   .INTERFACE_TYPE("MEMORY"),   // "MEMORY", "MEMORY_DDR3", "MEMORY_QDR", "NETWORKING", or "OVERSAMPLE"
   .IOBDELAY("NONE"),           // "NONE", "IBUF", "IFD", "BOTH"
   .NUM_CE(2),                  // Number of clock enables (1 or 2)
   .OFB_USED("FALSE"),          // Select OFB path (TRUE/FALSE)
   .SERDES_MODE("MASTER"),      // "MASTER" or "SLAVE"
   // SRVAL_Q1 - SRVAL_Q4: Q output values when SR is used (0/1)
   .SRVAL_Q1(1'b0),
   .SRVAL_Q2(1'b0),
   .SRVAL_Q3(1'b0),
   .SRVAL_Q4(1'b0) 
)
ISERDESE1_inst (
   .O(O),                       // 1-bit output: Combinatorial output
   // Q1 - Q6: 1-bit (each) output: Registered data outputs
   .Q1(Q1),
   .Q2(Q2),
   .Q3(Q3),
   .Q4(Q4),
   .Q5(Q5),
   .Q6(Q6),
   // SHIFTOUT1-SHIFTOUT2: 1-bit (each) output: Data width expansion output ports
   .SHIFTOUT1(SHIFTOUT1),
   .SHIFTOUT2(SHIFTOUT2),
   .BITSLIP(BITSLIP),           // 1-bit input: Bitslip enable input
   // CE1, CE2: 1-bit (each) input: Data register clock enable inputs
   .CE1(CE1),
   .CE2(CE2),
   // Clocks: 1-bit (each) input: ISERDESE1 clock input ports
   .CLK(CLK),                   // 1-bit input: High-speed clock input
   .CLKB(CLKB),                 // 1-bit input: High-speed secondary clock input
   .CLKDIV(CLKDIV),             // 1-bit input: Divided clock input
   .OCLK(OCLK),                 // 1-bit input: High speed output clock input used when
                                // INTERFACE_TYPE="MEMORY"

   // Dynamic Clock Inversions: 1-bit (each) input: Dynamic clock inversion pins to switch clock polarity
   .DYNCLKDIVSEL(DYNCLKDIVSEL), // 1-bit input: Dynamic CLKDIV inversion input
   .DYNCLKSEL(DYNCLKSEL),       // 1-bit input: Dynamic CLK/CLKB inversion input
   // Input Data: 1-bit (each) input: ISERDESE1 data input ports
   .D(D),                       // 1-bit input: Data input
   .DDLY(DDLY),                 // 1-bit input: Serial input data from IODELAYE1
   .OFB(OFB),                   // 1-bit input: Data feedback input from OSERDESE1
   .RST(RST),                   // 1-bit input: Active high asynchronous reset input
   // SHIFTIN1-SHIFTIN2: 1-bit (each) input: Data width expansion input ports
   .SHIFTIN1(SHIFTIN1),
   .SHIFTIN2(SHIFTIN2) 
);

// End of ISERDESE1_inst instantiation
