//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2009 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, Inc.
// All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor: Xilinx
// \   \   \/    Version: 11.2
//  \   \        Application: Partial Reconfiguration
//  /   /        Filename: red_fast.v
// /___/   /\    Date Last Modified: 9 August 2009
// \   \  /  \   
//  \___\/\___\
// Device: Virtex-5
// Design Name: Color2
// Purpose: Partial Reconfiguration User Guide
///////////////////////////////////////////////////////////////////////////////
// fast blinking LED, no modification to DVI_out

module rm_red ( 
	rst_n, 
	clk, 
	out,
	DVI_in0,
	DVI_in1,
	DVI_in2,
	DVI_in3,
	DVI_in4,
	DVI_in5,
	DVI_in6,
	DVI_in7,
	DVI_out0,
	DVI_out1,
	DVI_out2,
	DVI_out3,
	DVI_out4,
	DVI_out5,
	DVI_out6,
	DVI_out7);

   input rst_n;            // Active high reset, synchronous with 27MHz clock
   input clk;              // 100MHz input clock
   input  DVI_in0, DVI_in1, DVI_in2, DVI_in3,
          DVI_in4, DVI_in5, DVI_in6, DVI_in7;     // DVI_R input signal from DVI module
   output out;             // Output to LED
   output DVI_out0, DVI_out1, DVI_out2, DVI_out3,
          DVI_out4, DVI_out5, DVI_out6, DVI_out7; // modified DVI_R output signal

// wire the color space directly to DVI port, no modification
   assign DVI_out0 = DVI_in0;
   assign DVI_out1 = DVI_in1;
   assign DVI_out2 = DVI_in2;
   assign DVI_out3 = DVI_in3;
   assign DVI_out4 = DVI_in4;
   assign DVI_out5 = DVI_in5;
   assign DVI_out6 = DVI_in6;
   assign DVI_out7 = DVI_in7;
	
   led_fast led_fast_inst (rst_n, clk, out); 
   
endmodule
