-- FIFO18: 16k+2k Parity Synchronous/Asynchronous BlockRAM FIFO BlockRAM Memory
--         Virtex-5 
-- Xilinx HDL Libraries Guide, version 13.2

FIFO18_inst : FIFO18
generic map (
   ALMOST_FULL_OFFSET => X"080",  -- Sets almost full threshold
   ALMOST_EMPTY_OFFSET => X"080", -- Sets the almost empty threshold
   DATA_WIDTH => 4,               -- Sets data width to 4, 9, or 18
   DO_REG => 1,                   -- Enable output register ( 0 or 1)
                                  -- Must be 1 if the EN_SYN = FALSE
   EN_SYN => FALSE,               -- Specified FIFO as Asynchronous (FALSE) or 
                                  -- Synchronous (TRUE)
   FIRST_WORD_FALL_THROUGH => FALSE, -- Sets the FIFO FWFT to TRUE or FALSE
   SIM_MODE => "SAFE") -- Simulation: "SAFE" vs "FAST", see "Synthesis and Simulation
                       -- Design Guide" for details
port map (
   ALMOSTEMPTY => ALMOSTEMPTY,   -- 1-bit almost empty output flag
   ALMOSTFULL => ALMOSTFULL,     -- 1-bit almost full output flag
   DO => DO,                     -- 32-bit data output
   DOP => DOP,                   -- 2-bit parity data output
   EMPTY => EMPTY,               -- 1-bit empty output flag
   FULL => FULL,                 -- 1-bit full output flag
   RDCOUNT => RDCOUNT,           -- 12-bit read count output
   RDERR => RDERR,               -- 1-bit read error output
   WRCOUNT => WRCOUNT,           -- 12-bit write count output
   WRERR => WRERR,               -- 1-bit write error
   DI => DI,                     -- 16-bit data input
   DIP => DIP,                   -- 2-bit parity input
   RDCLK => RDCLK,               -- 1-bit read clock input
   RDEN => RDEN,                 -- 1-bit read enable input
   RST => RST,                   -- 1-bit reset input
   WRCLK => WRCLK,               -- 1-bit write clock input
   WREN => WREN                  -- 1-bit write enable input
);

-- End of FIFO18_inst instantiation
