// IOBUFDS_INTERMDISABLE: Differential Bi-directional Buffer with Input Termination
//                        and Input path enable/disable
//                        May only be placed in High Range (HR) Banks
//                        7 Series
// Xilinx HDL Libraries Guide, version 13.3

IOBUFDS_INTERMDISABLE #(
   .DIFF_TERM("FALSE"),     // Differential Termination ("TRUE"/"FALSE")
   .IBUF_LOW_PWR("TRUE"),   // Low Power - "TRUE", High Performance = "FALSE"
   .IOSTANDARD("BLVDS_25"), // Specify the I/O standard
   .SLEW("SLOW"),           // Specify the output slew rate
   .USE_IBUFDISABLE("TRUE") // Use IBUFDISABLE function, "TRUE" or "FALSE"
) IOBUFDS_INTERMDISABLE_inst (
   .O(O),     // Buffer output
   .IO(IO),   // Diff_p inout (connect directly to top-level port)
   .IOB(IOB), // Diff_n inout (connect directly to top-level port)
   .I(I),     // Buffer input
   .IBUFDISABLE(IBUFDISABLE),     // Input disable input, low=disable
   .INTERMDISABLE(INTERMDISABLE), // Input termination disable input
   .T(T)      // 3-state enable input, high=input, low=output
);
  
// End of IOBUFDS_INTERMDISABLE_inst instantiation
