-- FIFO_DUALCLOCK_MACRO: Dual-Clock First-In, First-Out (FIFO) RAM Buffer
--                       Virtex-5
-- Xilinx HDL Libraries Guide, version 13.4

-- Note -  This Unimacro model assumes the port directions to be "downto". 
--         Simulation of this model with "to" in the port directions could lead to erroneous results.

FIFO_DUALCLOCK_MACRO_inst : FIFO_DUALCLOCK_MACRO
generic map (
   DEVICE => "VIRTEX5",            -- Target Device: "VIRTEX5", "VIRTEX6"
   ALMOST_FULL_OFFSET => X"0080",  -- Sets almost full threshold
   ALMOST_EMPTY_OFFSET => X"0080", -- Sets the almost empty threshold
   DATA_WIDTH => 0,   -- Valid values are 1-72 (37-72 only valid when FIFO_SIZE="36Kb")
   FIFO_SIZE => "18Kb",            -- Target BRAM, "18Kb" or "36Kb" 
   FIRST_WORD_FALL_THROUGH => FALSE, -- Sets the FIFO FWFT to TRUE or FALSE
   SIM_MODE => "SAFE") -- Simulation "SAFE" vs "FAST", 
                       -- see "Synthesis and Simulation Design Guide" for details
port map (
   ALMOSTEMPTY => ALMOSTEMPTY,   -- Output almost empty 
   ALMOSTFULL => ALMOSTFULL,     -- Output almost full
   DO => DO,                     -- Output data
   EMPTY => EMPTY,               -- Output empty
   FULL => FULL,                 -- Output full
   RDCOUNT => RDCOUNT,           -- Output read count
   RDERR => RDERR,               -- Output read error
   WRCOUNT => WRCOUNT,           -- Output write count
   WRERR => WRERR,               -- Output write error
   DI => DI,                     -- Input data
   RDCLK => RDCLK,               -- Input read clock
   RDEN => RDEN,                 -- Input read enable
   RST => RST,                   -- Input reset
   WRCLK => WRCLK,               -- Input write clock
   WREN => WREN                  -- Input write enable
);
-- End of FIFO_DUALCLOCK_MACRO_inst instantiation
