-- RAMB18E1: 18K-bit Configurable Synchronous Block RAM
--           Virtex-6
-- Xilinx HDL Libraries Guide, version 14.1

RAMB18E1_inst : RAMB18E1
generic map (
   -- Colision check: Values ("ALL", "WARNING_ONLY", "GENERATE_X_ONLY" or "NONE")
   SIM_COLLISION_CHECK => "ALL",
   -- DOA_REG, DOB_REG: Optional output register (0 or 1)
   DOA_REG => 0,
   DOB_REG => 0,
   -- INITP_00 to INITP_07: Initial contents of parity memory array
   INITP_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
   -- INIT_00 to INIT_3F: Initial contents of data memory array
   INIT_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_08 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_09 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_10 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_11 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_12 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_13 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_14 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_15 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_16 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_17 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_18 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_19 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_20 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_21 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_22 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_23 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_24 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_25 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_26 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_27 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_28 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_29 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_2F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_30 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_31 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_32 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_33 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_34 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_35 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_36 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_37 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_38 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_39 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_3F => X"0000000000000000000000000000000000000000000000000000000000000000",
   -- INIT_A, INIT_B: Initial values on output ports
   INIT_A => X"00000",
   INIT_B => X"00000",
   INIT_FILE => "NONE",                                                             -- RAM init file
   RAM_MODE => "TDP",                                                               -- "SDP" or "TDP"
   RDADDR_COLLISION_HWCONFIG => "DELAYED_WRITE",                                    -- "PERFORMANCE" or
                                                                                    -- "DELAYED_WRITE"
   -- READ_WIDTH_A/B, WRITE_WIDTH_A/B: Read/write width per port
   READ_WIDTH_A => 0,                                                               -- 0,1,2,4,9,18,36
   READ_WIDTH_B => 0,                                                               -- 0,1,2,4,9,18
   WRITE_WIDTH_A => 0,                                                              -- 0,1,2,4,9,18
   WRITE_WIDTH_B => 0,                                                              -- 0,1,2,4,9,18,36
   -- RSTREG_PRIORITY_A, RSTREG_PRIORITY_B: Reset or enable priority ("RSTREG" or "REGCE")
   RSTREG_PRIORITY_A => "RSTREG",
   RSTREG_PRIORITY_B => "RSTREG",
   -- SRVAL_A, SRVAL_B: Set/reset value for output
   SRVAL_A => X"00000",
   SRVAL_B => X"00000",
   -- WriteMode: Value on output upon a write ("WRITE_FIRST", "READ_FIRST", or "NO_CHANGE")
   WRITE_MODE_A => "WRITE_FIRST",
   WRITE_MODE_B => "WRITE_FIRST" 
)
port map (
   -- Port A Data: 16-bit (each) output: Port A data
   DOADO => DOADO,                 -- 16-bit output: A port data/LSB data output
   DOPADOP => DOPADOP,             -- 2-bit output: A port parity/LSB parity output
   -- Port B Data: 16-bit (each) output: Port B data
   DOBDO => DOBDO,                 -- 16-bit output: B port data/MSB data output
   DOPBDOP => DOPBDOP,             -- 2-bit output: B port parity/MSB parity output
   -- Port A Address/Control Signals: 14-bit (each) input: Port A address and control signals (read port
   -- when RAM_MODE="SDP")
   ADDRARDADDR => ADDRARDADDR,     -- 14-bit input: A port address/Read address input
   CLKARDCLK => CLKARDCLK,         -- 1-bit input: A port clock/Read clock input
   ENARDEN => ENARDEN,             -- 1-bit input: A port enable/Read enable input
   REGCEAREGCE => REGCEAREGCE,     -- 1-bit input: A port register enable/Register enable input
   RSTRAMARSTRAM => RSTRAMARSTRAM, -- 1-bit input: A port set/reset input
   RSTREGARSTREG => RSTREGARSTREG, -- 1-bit input: A port register set/reset input
   WEA => WEA,                     -- 2-bit input: A port write enable input
   -- Port A Data: 16-bit (each) input: Port A data
   DIADI => DIADI,                 -- 16-bit input: A port data/LSB data input
   DIPADIP => DIPADIP,             -- 2-bit input: A port parity/LSB parity input
   -- Port B Address/Control Signals: 14-bit (each) input: Port B address and control signals (write port
   -- when RAM_MODE="SDP")
   ADDRBWRADDR => ADDRBWRADDR,     -- 14-bit input: B port address/Write address input
   CLKBWRCLK => CLKBWRCLK,         -- 1-bit input: B port clock/Write clock input
   ENBWREN => ENBWREN,             -- 1-bit input: B port enable/Write enable input
   REGCEB => REGCEB,               -- 1-bit input: B port register enable input
   RSTRAMB => RSTRAMB,             -- 1-bit input: B port set/reset input
   RSTREGB => RSTREGB,             -- 1-bit input: B port register set/reset input
   WEBWE => WEBWE,                 -- 4-bit input: B port write enable/Write enable input
   -- Port B Data: 16-bit (each) input: Port B data
   DIBDI => DIBDI,                 -- 16-bit input: B port data/MSB data input
   DIPBDIP => DIPBDIP              -- 2-bit input: B port parity/MSB parity input
);

-- End of RAMB18E1_inst instantiation
