-- SYSMON: System Monitor
--         Virtex-6
-- Xilinx HDL Libraries Guide, version 14.1

SYSMON_inst : SYSMON
generic map (
   -- INIT_40 - INIT_42: System Monitor configuration registers
   INIT_40 => X"0000",
   INIT_41 => X"0000",
   INIT_42 => X"0800",
   -- INIT_43 - INIT_47: System Monitor Test registers (do not edit)
   INIT_43 => X"0000",
   INIT_44 => X"0000",
   INIT_45 => X"0000",
   INIT_46 => X"0000",
   INIT_47 => X"0000",
   -- INIT_48 - INIT_4F: Sequence registers for the Channel Sequencer
   INIT_48 => X"0000",
   INIT_49 => X"0000",
   INIT_4A => X"0000",
   INIT_4B => X"0000",
   INIT_4C => X"0000",
   INIT_4D => X"0000",
   INIT_4E => X"0000",
   INIT_4F => X"0000",
   -- INIT_50 - INIT_57: Alarm threshold registers
   INIT_50 => X"0000",
   INIT_51 => X"0000",
   INIT_52 => X"0000",
   INIT_53 => X"0000",
   INIT_54 => X"0000",
   INIT_55 => X"0000",
   INIT_56 => X"0000",
   INIT_57 => X"0000",
   -- Simulation attributes: Set for proepr simulation behavior
   SIM_DEVICE => "VIRTEX5",          -- Must be set to VIRTEX6
   SIM_MONITOR_FILE => "design.txt"  -- Analog simulation data file name
)
port map (
   -- Alarm Ports: 3-bit (each) output: ALM, OT
   ALM => ALM,                   -- 3-bit output: output alarm for temp, Vccint and Vccaux
   OT => OT,                     -- 1-bit output: Over-Temperature alarm output
   -- DRP Ports: 16-bit (each) output: Dynamic Reconfiguration Ports
   DO => DO,                     -- 16-bit output: DRP output data bus
   DRDY => DRDY,                 -- 1-bit output: DRP data ready output signal
   -- Status Ports: 1-bit (each) output: SYSMON status ports
   BUSY => BUSY,                 -- 1-bit output: ADC busy output
   CHANNEL => CHANNEL,           -- 5-bit output: Channel selection outputs
   EOC => EOC,                   -- 1-bit output: End of Conversion output
   EOS => EOS,                   -- 1-bit output: End of Sequence output
   JTAGBUSY => JTAGBUSY,         -- 1-bit output: JTAG DRP transaction in progress output
   JTAGLOCKED => JTAGLOCKED,     -- 1-bit output: JTAG requested DRP port lock output
   JTAGMODIFIED => JTAGMODIFIED, -- 1-bit output: JTAG Write to the DRP has occurred output
   -- Auxiliary Analog-Input Pairs: 16-bit (each) input: VAUXP[15:0], VAUXN[15:0]
   VAUXN => VAUXN,               -- 16-bit input: N-side auxiliary analog input
   VAUXP => VAUXP,               -- 16-bit input: P-side auxiliary analog input
   -- Control and Clock Ports: 1-bit (each) input: Reset and Converstion Start
   CONVST => CONVST,             -- 1-bit input: Convert start input
   CONVSTCLK => CONVSTCLK,       -- 1-bit input: Convert start input
   RESET => RESET,               -- 1-bit input: Active-high reset input
   -- DRP Ports: 7-bit (each) input: Dynamic Reconfiguration Ports
   DADDR => DADDR,               -- 7-bit input: DRP input address bus
   DCLK => DCLK,                 -- 1-bit input: DRP clock input
   DEN => DEN,                   -- 1-bit input: DRP input enable signal
   DI => DI,                     -- 16-bit input: DRP input data bus
   DWE => DWE,                   -- 1-bit input: DRP write enable input
   -- Dedicated Analog Input Pair: 1-bit (each) input: VP/VN
   VN => VN,                     -- 1-bit input: N-side analog input
   VP => VP                      -- 1-bit input: P-side analog input
);

-- End of SYSMON_inst instantiation
