// FIFO18E1: 18KB FIFO (First In, First Out) Block RAM Memory
//           Virtex-6
// Xilinx HDL Libraries Guide, version 14.1

FIFO18E1 #(
   .ALMOST_EMPTY_OFFSET(13'h0080),    // Sets the almost empty threshold
   .ALMOST_FULL_OFFSET(13'h0080),     // Sets almost full threshold
   .DATA_WIDTH(4),                    // Sets data width to 4, 9, 18, or 36
   .DO_REG(1),                        // Enable output register (0 or 1) Must be 1 if EN_SYN = FALSE
   .EN_SYN("FALSE"),                  // Specifies FIFO as dual-clock (FALSE) or Synchronous (TRUE)
   .FIFO_MODE("FIFO18"),              // Sets mode to FIFO18 or FIFO18_36
   .FIRST_WORD_FALL_THROUGH("FALSE"), // Sets the FIFO FWFT to TRUE or FALSE
   .INIT(36'h000000000),              // Initial values on output port
   .SRVAL(36'h000000000)              // Set/Reset value for output port
)
FIFO18E1_inst (
   // Read Data: 32-bit (each) output: Read output data
   .DO(DO),                   // 32-bit output: data output
   .DOP(DOP),                 // 4-bit output: parity data output
   // Status: 1-bit (each) output: Flags and other FIFO status outputs
   .ALMOSTEMPTY(ALMOSTEMPTY), // 1-bit output: almost empty output flag
   .ALMOSTFULL(ALMOSTFULL),   // 1-bit output: almost full output flag
   .EMPTY(EMPTY),             // 1-bit output: empty output flag
   .FULL(FULL),               // 1-bit output: full output flag
   .RDCOUNT(RDCOUNT),         // 12-bit output: read count output
   .RDERR(RDERR),             // 1-bit output: read error output
   .WRCOUNT(WRCOUNT),         // 12-bit output: write count output
   .WRERR(WRERR),             // 1-bit output: write error
   // Read Control Signals: 1-bit (each) input: Read clock, enable and reset input signals
   .RDCLK(RDCLK),             // 1-bit input: read clock input
   .RDEN(RDEN),               // 1-bit input: read enable input
   .REGCE(REGCE),             // 1-bit input: clock enable input
   .RST(RST),                 // 1-bit input: reset input
   .RSTREG(RSTREG),           // 1-bit input: output register set/reset
   // Write Control Signals: 1-bit (each) input: Write clock and enable input signals
   .WRCLK(WRCLK),             // 1-bit input: write clock input
   .WREN(WREN),               // 1-bit input: write enable input
   // Write Data: 32-bit (each) input: Write input data
   .DI(DI),                   // 32-bit input: data input
   .DIP(DIP)                  // 4-bit input: parity input
);

// End of FIFO18E1_inst instantiation
