-- BSCAN_VIRTEX4: Boundary Scan primitve for connecting internal logic to
--                JTAG interface. 
--                Virtex-4
-- Xilinx HDL Libraries Guide, version 13.4

BSCAN_VIRTEX4_inst : BSCAN_VIRTEX4 
generic map (
   JTAG_CHAIN => 1) -- Value to set BSCAN site of device. Possible values: (1,2,3 or 4)
port map (
   CAPTURE => CAPTURE, -- CAPTURE output from TAP controller
   DRCK => DRCK,       -- Data register output for USER functions
   RESET => RESET,     -- Reset output from TAP controller
   SEL => SEL,         -- USER active output
   SHIFT => SHIFT,     -- SHIFT output from TAP controller
   TDI => TDI,         -- TDI output from TAP controller
   UPDATE => UPDATE,   -- UPDATE output from TAP controller
   TDO => TDO          -- Data input for USER function
);

-- End of BSCAN_VIRTEX4_inst instantiation
