// IBUF_INTERMDISABLE: Single-ended Input Buffer with Termination Input Disable
//                     May only be placed in High Range (HR) Banks
//                     7 Series
// Xilinx HDL Libraries Guide, version 13.4

IBUF_INTERMDISABLE #(
   .IBUF_LOW_PWR("TRUE"),   // Low power ("TRUE") vs. performance ("FALSE") for referenced I/O standards 
   .IOSTANDARD("DEFAULT"),  // Specify the input I/O standard
   .USE_IBUFDISABLE("TRUE") // Set to "TRUE" to enable IBUFDISABLE feature
) IBUF_INTERMDISABLE_inst (
   .O(O),                    // Buffer output
   .I(I),                    // Buffer input (connect directly to top-level port)
   .IBUFDISABLE(IBUFDISABLE),    // Buffer disable input, low=disable
   .INTERMDISABLE(INTERMDISABLE) // Input Termination Disable
);
  
// End of IBUF_INTERMDISABLE_inst instantiation
