// IOBUF_INTERMDISABLE: Single-ended Bi-directional Buffer with Input Termination
//                      and Input path enable/disable
//                      May only be placed in High Range (HR) Banks
//                      7 Series
// Xilinx HDL Libraries Guide, version 13.4

IOBUF_INTERMDISABLE #(
   .DRIVE(12), // Specify the output drive strength
   .IBUF_LOW_PWR("TRUE"),  // Low Power - "TRUE", High Performance = "FALSE"
   .IOSTANDARD("DEFAULT"), // Specify the I/O standard
   .SLEW("SLOW"),          // Specify the output slew rate
   .USE_IBUFDISABLE("TRUE") // Use IBUFDISABLE function, "TRUE" or "FALSE"
) IOBUF_INTERMDISABLE_inst (
   .O(O),     // Buffer output
   .IO(IO),   // Buffer inout port (connect directly to top-level port)
   .I(I),     // Buffer input
   .IBUFDISABLE(IBUFDISABLE), // Input disable input, low=disable
   .INTERMDISABLE(INTERMDISABLE), // Input termination disable input
   .T(T)      // 3-state enable input, high=input, low=output
);
  
// End of IOBUF_INTERMDISABLE_inst instantiation
