// SPI_ACCESS2: Internal Logic Access to the Serial Peripheral Interface (SPI) PROM Data
//              Spartan-6
// Xilinx HDL Libraries Guide, version 13.4

SPI_ACCESS2 #(
   .SIM_DELAY_TYPE("SCALED"),                                                                                                                              // Scales
                                                                                                                                                           // down
                                                                                                                                                           // some
                                                                                                                                                           // timing
                                                                                                                                                           // delays
                                                                                                                                                           // for
                                                                                                                                                           // faster
                                                                                                                                                           // simulation
                                                                                                                                                           // run.
                                                                                                                                                           // 'ACCURATE'
                                                                                                                                                           // =
                                                                                                                                                           // timing
                                                                                                                                                           // and
                                                                                                                                                           // delays
                                                                                                                                                           // consistent
                                                                                                                                                           // with
                                                                                                                                                           // datasheet
                                                                                                                                                           // specs.
                                                                                                                                                           // 'SCALED'
                                                                                                                                                           // =
                                                                                                                                                           // timing
                                                                                                                                                           // numbers
                                                                                                                                                           // scaled
                                                                                                                                                           // back
                                                                                                                                                           // to
                                                                                                                                                           // run
                                                                                                                                                           // faster
                                                                                                                                                           // simulation,
                                                                                                                                                           // behavior
                                                                                                                                                           // not
                                                                                                                                                           // affected.
   .SIM_DEVICE("SA16N"),                                                                                                                                   // Specifies
                                                                                                                                                           // the
                                                                                                                                                           // target
                                                                                                                                                           // device
                                                                                                                                                           // so
                                                                                                                                                           // that
                                                                                                                                                           // the
                                                                                                                                                           // proper
                                                                                                                                                           // size
                                                                                                                                                           // ISF
                                                                                                                                                           // Memory
                                                                                                                                                           // is
                                                                                                                                                           // used.
                                                                                                                                                           // This
                                                                                                                                                           // attribute
                                                                                                                                                           // must
                                                                                                                                                           // be
                                                                                                                                                           // set.
   .SIM_FACTORY_ID(512'h00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), // Specifies
                                                                                                                                                           // the
                                                                                                                                                           // Unique
                                                                                                                                                           // Identifier
                                                                                                                                                           // value
                                                                                                                                                           // in
                                                                                                                                                           // the
                                                                                                                                                           // Security
                                                                                                                                                           // Register
                                                                                                                                                           // for
                                                                                                                                                           // simulation
                                                                                                                                                           // purposes
                                                                                                                                                           // (the
                                                                                                                                                           // actual
                                                                                                                                                           // HW
                                                                                                                                                           // value
                                                                                                                                                           // will
                                                                                                                                                           // be
                                                                                                                                                           // specific
                                                                                                                                                           // to
                                                                                                                                                           // the
                                                                                                                                                           // particular
                                                                                                                                                           // device
                                                                                                                                                           // used).
   .SIM_MEM_FILE("NONE"),                                                                                                                                  // Optionally
                                                                                                                                                           // specifies
                                                                                                                                                           // a
                                                                                                                                                           // hex
                                                                                                                                                           // file
                                                                                                                                                           // containing
                                                                                                                                                           // the
                                                                                                                                                           // initialization
                                                                                                                                                           // memory
                                                                                                                                                           // content
                                                                                                                                                           // for
                                                                                                                                                           // the
                                                                                                                                                           // ISF
                                                                                                                                                           // Memory.
   .SIM_USER_ID(512'hffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff)     // Specifies
                                                                                                                                                           // the
                                                                                                                                                           // programmed
                                                                                                                                                           // USER
                                                                                                                                                           // ID
                                                                                                                                                           // in
                                                                                                                                                           // the
                                                                                                                                                           // Security
                                                                                                                                                           // Register
                                                                                                                                                           // for
                                                                                                                                                           // the
                                                                                                                                                           // ISF
                                                                                                                                                           // Memory.
)
SPI_ACCESS2_inst (
   .MISO(MISO), // 1-bit output: Serial output data from the ISF Memory.
   .CLK(CLK),   // 1-bit input: ISF Memory clock
   .CSB(CSB),   // 1-bit input: ISF Memory enable
   .MOSI(MOSI)  // 1-bit input: Serial input instructions/data to the ISF Memory
);

// End of SPI_ACCESS2_inst instantiation
