// FIFO18_36: 36x18k Synchronous/Asynchronous BlockRAM FIFO
//            Virtex-5
// Xilinx HDL Libraries Guide, version 13.4

FIFO18_36 #(
   .SIM_MODE("SAFE"),  // Simulation: "SAFE" vs. "FAST", see "Synthesis and Simulation Design Guide" for details
   .ALMOST_FULL_OFFSET(9'h080),      // Sets almost full threshold
   .ALMOST_EMPTY_OFFSET(9'h080),     // Sets the almost empty threshold
   .DO_REG(1),                       // Enable output register (0 or 1)
                                     //   Must be 1 if EN_SYN = "FALSE"
   .EN_SYN("FALSE"),                 // Specifies FIFO as Asynchronous ("FALSE") 
                                     //   or Synchronous ("TRUE")
   .FIRST_WORD_FALL_THROUGH("FALSE") // Sets the FIFO FWFT to "TRUE" or "FALSE" 
) FIFO18_36_inst (
   .ALMOSTEMPTY(ALMOSTEMPTY), // 1-bit almost empty output flag
   .ALMOSTFULL(ALMOSTFULL),   // 1-bit almost full output flag
   .DO(DO),                   // 32-bit data output
   .DOP(DOP),                 // 4-bit parity data output
   .EMPTY(EMPTY),             // 1-bit empty output flag
   .FULL(FULL),               // 1-bit full output flag
   .RDCOUNT(RDCOUNT),         // 9-bit read count output
   .RDERR(RDERR),             // 1-bit read error output
   .WRCOUNT(WRCOUNT),         // 9-bit write count output
   .WRERR(WRERR),             // 1-bit write error
   .DI(DI),                   // 32-bit data input
   .DIP(DIP),                 // 4-bit parity input
   .RDCLK(RDCLK),             // 1-bit read clock input
   .RDEN(RDEN),               // 1-bit read enable input
   .RST(RST),                 // 1-bit reset input
   .WRCLK(WRCLK),             // 1-bit write clock input
   .WREN(WREN)                // 1-bit write enable input
);   

// End of FIFO18_36_inst instantiation
