-- IBUF_INTERMDISABLE: Single-ended Input Buffer with Termination Input Disable
--                     May only be placed in High Range (HR) Banks
--                     7 Series
-- Xilinx HDL Libraries Guide, version 13.4

IBUF_INTERMDISABLE_inst : IBUF_INTERMDISABLE
generic map (
   IBUF_LOW_PWR => "TRUE", -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
   IOSTANDARD => "DEFAULT", -- Specify the input I/O standard
   USE_IBUFDISABLE => "TRUE") -- Set to "TRUE" to enable IBUFDISABLE feature
port map (
   O => O,     -- Buffer output
   I => I,     -- Buffer input (connect directly to top-level port)
   INTERMDISABLE => INTERMDISABLE, -- Input Termination Disable
   IBUFDISABLE => IBUFDISABLE -- Buffer disable input, low=disable
);
  
-- End of IBUF_INTERMDISABLE_inst instantiation
