// IOBUFDS_DIFF_OUT_DCIEN: Differential Bi-directional Buffer with Differential Output,
//                         Digital Controlled Impedance (DCI)and Input path enable/disable
//                         May only be placed in High Performance (HP) Banks
//                         7 Series
// Xilinx HDL Libraries Guide, version 13.4

IOBUFDS_DIFF_OUT_DCIEN #(
   .DIFF_TERM("FALSE"),     // Differential Termination ("TRUE"/"FALSE")
   .IBUF_LOW_PWR("TRUE"),   // Low Power - "TRUE", High Performance = "FALSE"
   .IOSTANDARD("BLVDS_25"), // Specify the I/O standard
   .USE_IBUFDISABLE("TRUE") // Use IBUFDISABLE function, "TRUE" or "FALSE"
) IOBUFDS_DIFF_OUT_DCIEN_inst (
   .O(O),     // Buffer p-side output
   .OB(OB),   // Buffer n-side output
   .IO(IO),   // Diff_p inout (connect directly to top-level port)
   .IOB(IOB), // Diff_n inout (connect directly to top-level port)
   .DCITERMDISABLE(DCITERMDISABLE), //  DCI Termination enable input
   .I(I),                           // Buffer input
   .IBUFDISABLE(IBUFDISABLE),       // Input disable input, low=disable
   .TM(TM),   // 3-state enable input, high=input, low=output
   .TS(TS)    // 3-state enable input, high=output, low=input
);
  
// End of IOBUFDS_DIFF_OUT_DCIEN_inst instantiation
