// DSP48: DSP Function Block
//        Virtex-4
// Xilinx HDL Libraries Guide, version 14.1

DSP48 #(
   .AREG(1),           // Number of pipeline registers on the A input, 0, 1 or 2
   .BREG(1),           // Number of pipeline registers on the B input, 0, 1 or 2
   .B_INPUT("DIRECT"), // B input DIRECT from fabric or CASCADE from another DSP48
   .CARRYINREG(1),     // Number of pipeline registers for the CARRYIN input, 0 or 1
   .CARRYINSELREG(1),  // Number of pipeline registers for the CARRYINSEL, 0 or 1
   .CREG(1),           // Number of pipeline registers on the C input, 0 or 1
   .LEGACY_MODE("MULT18X18S"), // Backward compatibility, NONE, MULT18X18 or MULT18X18S
   .MREG(1),           // Number of multiplier pipeline registers, 0 or 1
   .OPMODEREG(1),      // Number of pipeline regsiters on OPMODE input, 0 or 1
   .PREG(1),           // Number of pipeline registers on the P output, 0 or 1
   .SUBTRACTREG(1)     // Number of pipeline registers on the SUBTRACT input, 0 or 1
) DSP48_inst (
   .BCOUT(BCOUT),  // 18-bit B cascade output
   .P(P),          // 48-bit product output
   .PCOUT(PCOUT),  // 48-bit cascade output
   .A(A),          // 18-bit A data input
   .B(B),          // 18-bit B data input
   .BCIN(BCIN),    // 18-bit B cascade input
   .C(C),          // 48-bit cascade input
   .CARRYIN(CARRYIN), // Carry input signal
   .CARRYINSEL(CARRYINSEL), // 2-bit carry input select
   .CEA(CEA),      // A data clock enable input
   .CEB(CEB),      // B data clock enable input
   .CEC(CEC),      // C data clock enable input
   .CECARRYIN(CECARRYIN), // CARRYIN clock enable input
   .CECINSUB(CECINSUB), // CINSUB clock enable input
   .CECTRL(CECTRL), // Clock Enable input for CTRL regsiters
   .CEM(CEM),       // Clock Enable input for multiplier regsiters
   .CEP(CEP),       // Clock Enable input for P regsiters
   .CLK(CLK),       // Clock input
   .OPMODE(OPMODE), // 7-bit operation mode input
   .PCIN(PCIN),     // 48-bit PCIN input 
   .RSTA(RSTA),     // Reset input for A pipeline registers
   .RSTB(RSTB),     // Reset input for B pipeline registers
   .RSTC(RSTC),     // Reset input for C pipeline registers
   .RSTCARRYIN(RSTCARRYIN), // Reset input for CARRYIN registers
   .RSTCTRL(RSTCTRL), // Reset input for CTRL registers
   .RSTM(RSTM), // Reset input for multiplier registers
   .RSTP(RSTP), // Reset input for P pipeline registers
   .SUBTRACT(SUBTRACT) // SUBTRACT input
);

// End of DSP48_inst instantiation
