////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2002 Xilinx, Inc.  All rights reserved.
//
#include "xmk.h"
#include <xstatus.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <os_config.h>
#include <sys/process.h>
#include <pthread.h>
#include <xtmrctr_l.h>
#include <xuartlite_l.h>
#include <xintc_l.h>
#include "xparameters.h"

typedef unsigned char int_id_t;
volatile int count = 0;

/* Interrupt Handler*/
void button_interrupt_handler(void *baseaddr_p)
{
			xil_printf ("PUSH BUTTON: Push button interrupt[%d]\r\n", count);	
			count++;
}


void* push_main()
{
    int_id_t id = XPAR_XPS_INTC_0_SYSTEM_PUSH_BUTTON_PIN_INTR;
    XStatus status;
	
	/* Register interrupt handler*/
	if ((status = register_int_handler(id, button_interrupt_handler, NULL)) != XST_SUCCESS)
	{
		xil_printf ("PUSH BUTTON: Unable to register handler. Error code: %d.\r\n", status);
   }
   else
	{
		xil_printf ("PUSH BUTTON: push_button.c\r\n");
		xil_printf ("PUSH BUTTON: *****************************************************\r\n");
		xil_printf ("PUSH BUTTON: --                                                 --\r\n");
		xil_printf ("PUSH BUTTON: --                 Press Button                    --\r\n");
		xil_printf ("PUSH BUTTON: --                                                 --\r\n");
		xil_printf ("PUSH BUTTON: *****************************************************\r\n\r\n");
		
		/* Enable interrupts*/
		enable_interrupt(id);

		/* Wait for 10 interrupts to occur */
		xil_printf("PUSH BUTTON: Press Button ten times to exit...\r\n");
		while (count < 10)
		{
		}
		xil_printf("PUSH BUTTON: Exiting push_main...\r\n");
		/* Disable interrupts*/
		disable_interrupt(id);
		/* Return to shell_main.c*/
		pthread_exit (NULL);
	}

}
