-- RAMB8BWER: 8k-bit Data and 1k-bit Parity Configurable Synchronous Block RAM
--            Spartan-6
-- Xilinx HDL Libraries Guide, version 14.1

RAMB8BWER_inst : RAMB8BWER
generic map (
   -- DATA_WIDTH_A/DATA_WIDTH_B: 'If RAM_MODE="TDP": 0, 1, 2, 4, 9 or 18; If RAM_MODE="SDP": 36'
   DATA_WIDTH_A => 0,
   DATA_WIDTH_B => 0,
   -- DOA_REG/DOB_REG: Optional output register (0 or 1)
   DOA_REG => 0,
   DOB_REG => 0,
   -- EN_RSTRAM_A/EN_RSTRAM_B: Enable/disable RST
   EN_RSTRAM_A => TRUE,
   EN_RSTRAM_B => TRUE,
   -- INITP_00 to INITP_03: Initial memory contents.
   INITP_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INITP_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   -- INIT_00 to INIT_1F: Initial memory contents.
   INIT_00 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_01 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_08 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_09 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_0F => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_10 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_11 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_12 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_13 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_14 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_15 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_16 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_17 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_18 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_19 => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1A => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1B => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1C => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1D => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1E => X"0000000000000000000000000000000000000000000000000000000000000000",
   INIT_1F => X"0000000000000000000000000000000000000000000000000000000000000000",
   -- INIT_A/INIT_B: Initial values on output port
   INIT_A => X"00000",
   INIT_B => X"00000",
   -- INIT_FILE: Not Supported
   INIT_FILE => "NONE",                                                             -- Do not modify
   -- RAM_MODE: "SDP" or "TDP"
   RAM_MODE => "TDP",
   -- RSTTYPE: "SYNC" or "ASYNC"
   RSTTYPE => "SYNC",
   -- RST_PRIORITY_A/RST_PRIORITY_B: "CE" or "SR"
   RST_PRIORITY_A => "CE",
   RST_PRIORITY_B => "CE",
   -- SIM_COLLISION_CHECK: Collision check enable "ALL", "WARNING_ONLY", "GENERATE_X_ONLY" or "NONE"
   SIM_COLLISION_CHECK => "ALL",
   -- SRVAL_A/SRVAL_B: Set/Reset value for RAM output
   SRVAL_A => X"00000",
   SRVAL_B => X"00000",
   -- WRITE_MODE_A/WRITE_MODE_B: "WRITE_FIRST", "READ_FIRST", or "NO_CHANGE"
   WRITE_MODE_A => "WRITE_FIRST",
   WRITE_MODE_B => "WRITE_FIRST" 
)
port map (
   -- Port A Data: 16-bit (each) output: Port A data
   DOADO => DOADO,             -- 16-bit output: A port data/LSB data output
   DOPADOP => DOPADOP,         -- 2-bit output: A port parity/LSB parity output
   -- Port B Data: 16-bit (each) output: Port B data
   DOBDO => DOBDO,             -- 16-bit output: B port data/MSB data output
   DOPBDOP => DOPBDOP,         -- 2-bit output: B port parity/MSB parity output
   -- Port A Address/Control Signals: 13-bit (each) input: Port A address and control signals (write port
   -- when RAM_MODE="SDP")
   ADDRAWRADDR => ADDRAWRADDR, -- 13-bit input: A port address/Write address input
   CLKAWRCLK => CLKAWRCLK,     -- 1-bit input: A port clock/Write clock input
   ENAWREN => ENAWREN,         -- 1-bit input: A port enable/Write enable input
   REGCEA => REGCEA,           -- 1-bit input: A port register enable input
   RSTA => RSTA,               -- 1-bit input: A port set/reset input
   WEAWEL => WEAWEL,           -- 2-bit input: A port write enable input
   -- Port A Data: 16-bit (each) input: Port A data
   DIADI => DIADI,             -- 16-bit input: A port data/LSB data input
   DIPADIP => DIPADIP,         -- 2-bit input: A port parity/LSB parity input
   -- Port B Address/Control Signals: 13-bit (each) input: Port B address and control signals (read port
   -- when RAM_MODE="SDP")
   ADDRBRDADDR => ADDRBRDADDR, -- 13-bit input: B port address/Read address input
   CLKBRDCLK => CLKBRDCLK,     -- 1-bit input: B port clock/Read clock input
   ENBRDEN => ENBRDEN,         -- 1-bit input: B port enable/Read enable input
   REGCEBREGCE => REGCEBREGCE, -- 1-bit input: B port register enable/Register enable input
   RSTBRST => RSTBRST,         -- 1-bit input: B port set/reset input
   WEBWEU => WEBWEU,           -- 2-bit input: B port write enable input
   -- Port B Data: 16-bit (each) input: Port B data
   DIBDI => DIBDI,             -- 16-bit input: B port data/MSB data input
   DIPBDIP => DIPBDIP          -- 2-bit input: B port parity/MSB parity input
);

-- End of RAMB8BWER_inst instantiation
