-- IBUFDS_DIFF_OUT_IBUFDISABLE: Differential Input Buffer with Differential Output w/ Disable
--                              7 Series
-- Xilinx HDL Libraries Guide, version 14.1

IBUFDS_DIFF_OUT_IBUFDISABLE_inst : IBUFDS_DIFF_OUT_IBUFDISABLE
generic map (
   DIFF_TERM => "FALSE", -- Differential Termination 
   IBUF_LOW_PWR => "TRUE", -- Low power "TRUE" vs. performance "FALSE" setting for referenced I/O standards
   IOSTANDARD => "DEFAULT", -- Specify the input I/O standard
   USE_IBUFDISABLE => "TRUE") -- Set to "TRUE" to enable IBUFDISABLE feature
port map (
   O => O,     -- Buffer diff_p output
   OB => OB,   -- Buffer diff_n output
   I => I,  -- Diff_p buffer input (connect directly to top-level port)
   IB => IB, -- Diff_n buffer input (connect directly to top-level port)
   IBUFDISABLE => IBUFDISABLE -- Buffer disable input, low=disable
);

-- End of IBUFDS_DIFF_OUT_IBUFDISABLE_inst instantiation
