-- ODELAYE2: Output Fixed or Variable Delay Element
--           7 Series
-- Xilinx HDL Libraries Guide, version 14.1

ODELAYE2_inst : ODELAYE2
generic map (
   CINVCTRL_SEL => "FALSE",          -- Enable dynamic clock inversion (FALSE, TRUE)
   DELAY_SRC => "ODATAIN",           -- Delay input (ODATAIN, CLKIN)
   HIGH_PERFORMANCE_MODE => "FALSE", -- Reduced jitter ("TRUE"), Reduced power ("FALSE")
   ODELAY_TYPE => "FIXED",           -- FIXED, VARIABLE, VAR_LOAD, VAR_LOAD_PIPE
   ODELAY_VALUE => 0,                -- Output delay tap setting (0-31)
   PIPE_SEL => "FALSE",              -- Select pipelined mode, FALSE, TRUE
   REFCLK_FREQUENCY => 200.0,        -- IDELAYCTRL clock input frequency in MHz (190.0-210.0).
   SIGNAL_PATTERN => "DATA"          -- DATA, CLOCK input signal
)
port map (
   CNTVALUEOUT => CNTVALUEOUT, -- 5-bit output: Counter value output
   DATAOUT => DATAOUT,         -- 1-bit output: Delayed data/clock output
   C => C,                     -- 1-bit input: Clock input
   CE => CE,                   -- 1-bit input: Active high enable increment/decrement input
   CINVCTRL => CINVCTRL,       -- 1-bit input: Dynamic clock inversion input
   CLKIN => CLKIN,             -- 1-bit input: Clock delay input
   CNTVALUEIN => CNTVALUEIN,   -- 5-bit input: Counter value input
   INC => INC,                 -- 1-bit input: Increment / Decrement tap delay input
   LD => LD,                   -- 1-bit input: Loads ODELAY_VALUE tap delay in VARIABLE mode, in VAR_LOAD or
                               -- VAR_LOAD_PIPE mode, loads the value of CNTVALUEIN

   LDPIPEEN => LDPIPEEN,       -- 1-bit input: Enables the pipeline register to load data
   ODATAIN => ODATAIN,         -- 1-bit input: Output delay data input
   REGRST => REGRST            -- 1-bit input: Active-high reset tap-delay input
);

-- End of ODELAYE2_inst instantiation
