// IBUFDS_IBUFDISABLE: Differential Input Buffer with Input Disable
//                     7 Series
// Xilinx HDL Libraries Guide, version 14.1

IBUFDS_IBUFDISABLE #(
   .DIFF_TERM("FALSE"),      // Differential Termination
   .IBUF_LOW_PWR("TRUE"),    // Low power="TRUE", Highest performance="FALSE"
   .IOSTANDARD("DEFAULT"),   // Specify the input I/O standard
   .USE_IBUFDISABLE("TRUE")  // Set to "TRUE" to enable IBUFDISABLE feature
) IBUFDS_IBUFDISABLE_inst (
   .O(O),   // Buffer output
   .I(I),   // Diff_p buffer input (connect directly to top-level port)
   .IB(IB), // Diff_n buffer input (connect directly to top-level port)
   .IBUFDISABLE(IBUFDISABLE) // Buffer disable input, low=disable
);

// End of IBUFDS_IBUFDISABLE_inst instantiation
