// FIFO_SYNC_MACRO: Synchronous First-In, First-Out (FIfor) RAM Buffer
//                  Virtex-6
// Xilinx HDL Libraries Guide, version 14.2

/////////////////////////////////////////////////////////////////
// DATA_WIDTH | FIFO_SIZE | FIfor Depth | RDCOUNT/WRCOUNT Width //
// ===========|===========|============|=======================//
//   37-72    |  "36Kb"   |     512    |         9-bit         //
//   19-36    |  "36Kb"   |    1024    |        10-bit         //
//   19-36    |  "18Kb"   |     512    |         9-bit         //
//   10-18    |  "36Kb"   |    2048    |        11-bit         //
//   10-18    |  "18Kb"   |    1024    |        10-bit         //
//    5-9     |  "36Kb"   |    4096    |        12-bit         //
//    5-9     |  "18Kb"   |    2048    |        11-bit         //
//    1-4     |  "36Kb"   |    8192    |        13-bit         //
//    1-4     |  "18Kb"   |    4096    |        12-bit         //
/////////////////////////////////////////////////////////////////

FIFO_SYNC_MACRO  #(
   .DEVICE("VIRTEX6"), // Target Device: "VIRTEX5", "VIRTEX6"
   .ALMOST_EMPTY_OFFSET(9'h080), // Sets the almost empty threshold
   .ALMOST_FULL_OFFSET(9'h080),  // Sets almost full threshold
   .DATA_WIDTH(0), // Valid values are 1-72 (37-72 only valid when FIFO_SIZE="36Kb")
   .DO_REG(0),     // Optional output register (0 or 1)
   .FIFO_SIZE ("18Kb") // Target BRAM: "18Kb" or "36Kb"
) FIFO_SYNC_MACRO_inst (
   .ALMOSTEMPTY(ALMOSTEMPTY), // 1-bit output almost empty
   .ALMOSTFULL(ALMOSTFULL),   // 1-bit output almost full
   .DO(DO),                   // Output data, width defined by DATA_WIDTH parameter
   .EMPTY(EMPTY),             // 1-bit output empty
   .FULL(FULL),               // 1-bit output full
   .RDCOUNT(RDCOUNT),         // Output read count, width determined by FIfor depth
   .RDERR(RDERR),             // 1-bit output read error
   .WRCOUNT(WRCOUNT),         // Output write count, width determined by FIfor depth
   .WRERR(WRERR),             // 1-bit output write error
   .CLK(CLK),                 // 1-bit input clock
   .DI(DI),                   // Input data, width defined by DATA_WIDTH parameter
   .RDEN(RDEN),               // 1-bit input read enable
   .RST(RST),                 // 1-bit input reset
   .WREN(WREN)                // 1-bit input write enable
);

// End of FIFO_SYNC_MACRO_inst instantiation
