-- IOBUFDS_DCIEN: Differential Bi-directional Buffer with Digital Controlled Impedance (DCI)
--                and Input path enable/disable
--                May only be placed in High Performance (HP) Banks
--                7 Series
-- Xilinx HDL Libraries Guide, version 14.3

IOBUFDS_DCIEN_inst : IOBUFDS_DCIEN
generic map (
   DIFF_TERM => "FALSE", -- Differential termination (TRUE/FALSE)
   IBUF_LOW_PWR => "TRUE", -- Low Power - TRUE, HIGH Performance = FALSE
   IOSTANDARD => "BLVDS_25", -- Specify the I/O standard
   SLEW => "SLOW",   -- Specify the output slew rate
   USE_IBUFDISABLE => "TRUE") -- Use IBUFDISABLE function "TRUE" or "FALSE" 
port map (
   O => O,     -- Buffer output
   IO => IO,   -- Diff_p inout (connect directly to top-level port)
   IOB => IOB, -- Diff_n inout (connect directly to top-level port)
   DCITERMDISABLE => DCITERMDISABLE, -- DCI Termination enable input
   I => I,     -- Buffer input
   IBUFDISABLE => IBUFDISABLE, -- Input disable input, low=disable
   T => T      -- 3-state enable input, high=input, low=output
);
  
-- End of IOBUFDS_DCIEN_inst instantiation
