-- IOBUF_DCIEN: Single-ended Bi-directional Buffer with Digital Controlled Impedance (DCI)
--              and Input path enable/disable
--              May only be placed in High Performance (HP) Banks
--              7 Series
-- Xilinx HDL Libraries Guide, version 14.3

IOBUF_DCIEN_inst : IOBUF_DCIEN
generic map (
   DRIVE => 12,
   IOSTANDARD => "DEFAULT",
   IBUF_LOW_PWR => "TRUE",
   SLEW => "SLOW")
port map (
   O => O,     -- Buffer output
   IO => IO,   -- Buffer inout port (connect directly to top-level port)
   DCITERMDISABLE => DCITERMDISABLE, -- DCI Termination enable input
   I => I,     -- Buffer input
   IBUFDISABLE => IBUFDISABLE, -- Input disable input, low=disable 
   T => T      -- 3-state enable input, high=input, low=output 
);
  
-- End of IOBUF_DCIEN_inst instantiation
