-- IOBUF_INTERMDISABLE: Single-ended Bi-directional Buffer with Input Termination
--                      and Input path enable/disable
--                      May only be placed in High Range (HR) Banks
--                      7 Series
-- Xilinx HDL Libraries Guide, version 14.3

IOBUF_INTERMDISABLE_inst : IOBUF_INTERMDISABLE
generic map (
   DRIVE => 12,
   IOSTANDARD => "DEFAULT", -- Specify the I/O standard
   IBUF_LOW_PWR => "TRUE", -- Low Power - "TRUE", High Performance = "FALSE"
   USE_IBUFDISABLE => "TRUE", -- Use IBUFDISABLE function "TRUE" or "FALSE"
   SLEW => "SLOW")
port map (
   O => O,     -- Buffer output
   IO => IO,   -- Buffer inout port (connect directly to top-level port)
   DCITERMDISABLE => DCITERMDISABLE, -- DCI Termination enable input
   I => I,     -- Buffer input
   IBUFDISABLE => IBUFDISABLE, -- Input disable input, low=disable
   INTERMDISABLE => INTERMDISABLE, -- Input termination disable input
   T => T      -- 3-state enable input, high=input, low=output 
);
  
-- End of IOBUF_INTERMDISABLE_inst instantiation
