-- IDDR: Double Data Rate Input Register with Set, Reset
--       and Clock Enable. 
--       Virtex-6
-- Xilinx HDL Libraries Guide, version 14.3

IDDR_inst : IDDR 
generic map (
   DDR_CLK_EDGE => "OPPOSITE_EDGE", -- "OPPOSITE_EDGE", "SAME_EDGE" 
                                    -- or "SAME_EDGE_PIPELINED" 
   INIT_Q1 => '0', -- Initial value of Q1: '0' or '1'
   INIT_Q2 => '0', -- Initial value of Q2: '0' or '1'
   SRTYPE => "SYNC") -- Set/Reset type: "SYNC" or "ASYNC" 
port map (
   Q1 => Q1, -- 1-bit output for positive edge of clock 
   Q2 => Q2, -- 1-bit output for negative edge of clock
   C => C,   -- 1-bit clock input
   CE => CE, -- 1-bit clock enable input
   D => D,   -- 1-bit DDR data input
   R => R,   -- 1-bit reset
   S => S    -- 1-bit set
   );

-- End of IDDR_inst instantiation
