-- FIFO16: BlockRAM Asynchronous FIFO configured fro 4k deep x 4 wide
--         Virtex-4
-- Xilinx HDL Libraries Guide, version 14.1

FIFO16_inst : FIFO16
generic map (
   ALMOST_FULL_OFFSET => X"080",  -- Sets almost full threshold
   ALMOST_EMPTY_OFFSET => X"080", -- Sets the almost empty threshold
   DATA_WIDTH => 4, -- Sets data width to 4, 9, 18, or 36
   FIRST_WORD_FALL_THROUGH => FALSE) --Sets the FIFO FWFT to TRUE or FALSE
port map (
   ALMOSTEMPTY => ALMOSTEMPTY, -- 1-bit almost empty output flag
   ALMOSTFULL => ALMOSTFULL,   -- 1-bit almost full output flag
   DO (31 DOWNTO 4) => unconnected (27 downto 0), -- Unused data output. Unconnected is a signal of 32 bits
   DO (3 DOWNTO 0) => DO,      -- 4-bit data output
   DOP => unconnected (31 downto 28), -- 4-bit Unused parity data output. Unconnected is a signal of 32 bits
   EMPTY => EMPTY,             -- 1-bit empty output flag
   FULL => FULL,               -- 1-bit full output flag
   RDCOUNT => RDCOUNT,         -- 12-bit read count output
   RDERR => RDERR,             -- 1-bit read error output
   WRCOUNT => WRCOUNT,         -- 12-bit write count output
   WRERR => WRERR,             -- 1-bit write error
   DI (31 DOWNTO 4) => X"0000000", -- Unused data inputs tied to ground
   DI (3 downto 0) => DI,      -- 4-bit data input
   DIP => X"0",       -- 4-bit Unused parity inputs tied to ground
   RDCLK => RDCLK,    -- 1-bit read clock input
   RDEN => RDEN,      -- 1-bit read enable input
   RST => RST,        -- 1-bit reset input
   WRCLK => WRCLK,    -- 1-bit write clock input
   WREN => WREN       -- 1-bit write enable input
);

-- End of FIFO16_inst instantiation
