//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2009 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, Inc.
// All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor: Xilinx
// \   \   \/    Version: 11.2
//  \   \        Application: Partial Reconfiguration
//  /   /        Filename: top.v
// /___/   /\    Date Last Modified: 11 July 2009
// \   \  /  \
//  \___\/\___\
// Device: Virtex-5
// Design Name: Color2
// Purpose: Partial Reconfiguration User Guide
///////////////////////////////////////////////////////////////////////////////
/*
-  Description: This design generates color bars for the DVI output of the
                ML501 development board. The reconfigurable regions drives
                LEDs that change blinking frequency based on the PR modules
                loaded. The reconfigurable regions also control RGB component
                of the color bars. The partial bit files can be used to
                change the color space without losing horizontal and vertical
				synchronization.

----------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////////////////////
//  Top-level Design
//////////////////////////////////////////////////////////////////////////////
module top(
    rst,
    clk_p,
    clk_n,
    DVI_LCD_HSYNC,
    DVI_LCD_VSYNC,
    DVI_LCD_DE,
    DVI_LCD_CLK_P,
    DVI_LCD_CLK_N,
    DVI_LCD_DATA0,
    DVI_LCD_DATA1,
    DVI_LCD_DATA2,
    DVI_LCD_DATA3,
    DVI_LCD_DATA4,
    DVI_LCD_DATA5,
    DVI_LCD_DATA6,
    DVI_LCD_DATA7,
    DVI_LCD_DATA8,
    DVI_LCD_DATA9,
    DVI_LCD_DATA10,
    DVI_LCD_DATA11,
    DVI_LCD_RESET_B,
    DVI_IIC_SCL,
    DVI_IIC_SDA,
    out_r,
    out_g,
    out_b);

    input rst;     // Active high reset
    input clk_p;   // 200MHz input clock
    input clk_n;   // 200MHz input clock
    output DVI_LCD_HSYNC, DVI_LCD_VSYNC;
    output DVI_LCD_DE;
    output DVI_LCD_CLK_P;
    output DVI_LCD_CLK_N;
    output DVI_LCD_DATA0, DVI_LCD_DATA1, DVI_LCD_DATA2, DVI_LCD_DATA3;
    output DVI_LCD_DATA4, DVI_LCD_DATA5, DVI_LCD_DATA6, DVI_LCD_DATA7;
    output DVI_LCD_DATA8, DVI_LCD_DATA9, DVI_LCD_DATA10, DVI_LCD_DATA11;
    output DVI_LCD_RESET_B;
    output DVI_IIC_SDA;
    output DVI_IIC_SCL;

    output out_r;       // output to LED
    output out_g;       // output to LED
    output out_b;       // output to LED

	 wire rst;
	 wire DVI_DE;
	 wire DVI_LCD_HSYNC, DVI_LCD_VSYNC;
	 wire DVI_LCD_DE;
	 wire DVI_LCD_CLK_P;
	 wire DVI_LCD_CLK_N;
	 wire DVI_LCD_DATA0, DVI_LCD_DATA1, DVI_LCD_DATA2, DVI_LCD_DATA3;
	 wire DVI_LCD_DATA4, DVI_LCD_DATA5, DVI_LCD_DATA6, DVI_LCD_DATA7;
	 wire DVI_LCD_DATA8, DVI_LCD_DATA9, DVI_LCD_DATA10, DVI_LCD_DATA11;
	 wire DVI_LCD_RESET_B;
	 wire DVI_IIC_SDA_T;
	 wire DVI_IIC_SCL_T;
	 wire DVI_IIC_SDA;
	 wire DVI_IIC_SCL;

	wire DVI_HSYNC, DVI_VSYNC;
	wire [7:0] DVI_R, DVI_B, DVI_G;

	wire [7:0] DVI_R_bus_out;
	wire [7:0] DVI_G_bus_out;
	wire [7:0] DVI_B_bus_out;

	assign DVI_LCD_RESET_B = ~rst;

	assign DVI_IIC_SCL = DVI_IIC_SCL_T ? 1'bz : 1'b0;
	assign DVI_IIC_SDA = DVI_IIC_SDA_T ? 1'bz : 1'b0;

// instantiate static modules

clocks mmcm_clocks (
      .CLK_IN1_P(clk_p),
      .CLK_IN1_N(clk_n),
      .CLK_OUT1(clk_i),
      .CLK_OUT2(pixel_clock),
      .CLK_OUT3(DVI_CLK)
      );

dvi static_DVI (
      .rst_n(~rst),
      .pixel_clock(pixel_clock),
      .DVI_R(DVI_R_bus_out),
      .DVI_G(DVI_G_bus_out),
      .DVI_B(DVI_B_bus_out),
      .DVI_HSYNC(DVI_HSYNC),
      .DVI_VSYNC(DVI_VSYNC),
      .DATA_ENABLE(DVI_DE));

dvi_if static_DVI_IF (
      .clk(DVI_CLK),
      .rst(~rst),
      .HSYNC(DVI_HSYNC),
      .VSYNC(DVI_VSYNC),
      .DE(DVI_DE),
      .R0(DVI_R[0]),
      .R1(DVI_R[1]),
      .R2(DVI_R[2]),
      .R3(DVI_R[3]),
      .R4(DVI_R[4]),
      .R5(DVI_R[5]),
      .R6(DVI_R[6]),
      .R7(DVI_R[7]),
      .G0(DVI_G[0]),
      .G1(DVI_G[1]),
      .G2(DVI_G[2]),
      .G3(DVI_G[3]),
      .G4(DVI_G[4]),
      .G5(DVI_G[5]),
      .G6(DVI_G[6]),
      .G7(DVI_G[7]),
      .B0(DVI_B[0]),
      .B1(DVI_B[1]),
      .B2(DVI_B[2]),
      .B3(DVI_B[3]),
      .B4(DVI_B[4]),
      .B5(DVI_B[5]),
      .B6(DVI_B[6]),
      .B7(DVI_B[7]),
      .DVI_LCD_HSYNC(DVI_LCD_HSYNC),
      .DVI_LCD_VSYNC(DVI_LCD_VSYNC),
      .DVI_LCD_DE(DVI_LCD_DE),
      .DVI_LCD_CLK_P(DVI_LCD_CLK_P),
      .DVI_LCD_CLK_N(DVI_LCD_CLK_N),
      .DVI_LCD_DATA0(DVI_LCD_DATA0),
      .DVI_LCD_DATA1(DVI_LCD_DATA1),
      .DVI_LCD_DATA2(DVI_LCD_DATA2),
      .DVI_LCD_DATA3(DVI_LCD_DATA3),
      .DVI_LCD_DATA4(DVI_LCD_DATA4),
      .DVI_LCD_DATA5(DVI_LCD_DATA5),
      .DVI_LCD_DATA6(DVI_LCD_DATA6),
      .DVI_LCD_DATA7(DVI_LCD_DATA7),
      .DVI_LCD_DATA8(DVI_LCD_DATA8),
      .DVI_LCD_DATA9(DVI_LCD_DATA9),
      .DVI_LCD_DATA10(DVI_LCD_DATA10),
      .DVI_LCD_DATA11(DVI_LCD_DATA11));

iic_init static_IIC_INIT (
      .Clk(clk_i),
      .Reset_n(~rst),
      .Pixel_clk_greater_than_65Mhz(1'b0),
      .SDA(DVI_IIC_SDA_T),
      .SCL(DVI_IIC_SCL_T),
      .Done());

// instantiate red reconfigurable module
rm_red reconfig_red (
      .rst_n     (~rst),
      .clk       (clk_i),
      .out       (out_r),
      .DVI_in0   (DVI_R_bus_out[0]),
      .DVI_in1   (DVI_R_bus_out[1]),
      .DVI_in2   (DVI_R_bus_out[2]),
      .DVI_in3   (DVI_R_bus_out[3]),
      .DVI_in4   (DVI_R_bus_out[4]),
      .DVI_in5   (DVI_R_bus_out[5]),
      .DVI_in6   (DVI_R_bus_out[6]),
      .DVI_in7   (DVI_R_bus_out[7]),
      .DVI_out0  (DVI_R[0]),
      .DVI_out1  (DVI_R[1]),
      .DVI_out2  (DVI_R[2]),
      .DVI_out3  (DVI_R[3]),
      .DVI_out4  (DVI_R[4]),
      .DVI_out5  (DVI_R[5]),
      .DVI_out6  (DVI_R[6]),
      .DVI_out7  (DVI_R[7]));


// instantiate green reconfigurable module
rm_green reconfig_green (
      .rst_n     (~rst),
      .clk       (clk_i),
      .out       (out_g),
      .DVI_in0   (DVI_G_bus_out[0]),
      .DVI_in1   (DVI_G_bus_out[1]),
      .DVI_in2   (DVI_G_bus_out[2]),
      .DVI_in3   (DVI_G_bus_out[3]),
      .DVI_in4   (DVI_G_bus_out[4]),
      .DVI_in5   (DVI_G_bus_out[5]),
      .DVI_in6   (DVI_G_bus_out[6]),
      .DVI_in7   (DVI_G_bus_out[7]),
      .DVI_out0  (DVI_G[0]),
      .DVI_out1  (DVI_G[1]),
      .DVI_out2  (DVI_G[2]),
      .DVI_out3  (DVI_G[3]),
      .DVI_out4  (DVI_G[4]),
      .DVI_out5  (DVI_G[5]),
      .DVI_out6  (DVI_G[6]),
      .DVI_out7  (DVI_G[7]));


// instantiate blue reconfigurable module
rm_blue reconfig_blue (
	.rst_n     (~rst),
	.clk       (clk_i),
	.out       (out_b),
	.DVI_in0   (DVI_B_bus_out[0]),
	.DVI_in1   (DVI_B_bus_out[1]),
	.DVI_in2   (DVI_B_bus_out[2]),
	.DVI_in3   (DVI_B_bus_out[3]),
	.DVI_in4   (DVI_B_bus_out[4]),
	.DVI_in5   (DVI_B_bus_out[5]),
	.DVI_in6   (DVI_B_bus_out[6]),
	.DVI_in7   (DVI_B_bus_out[7]),
	.DVI_out0  (DVI_B[0]),
	.DVI_out1  (DVI_B[1]),
	.DVI_out2  (DVI_B[2]),
	.DVI_out3  (DVI_B[3]),
	.DVI_out4  (DVI_B[4]),
	.DVI_out5  (DVI_B[5]),
	.DVI_out6  (DVI_B[6]),
	.DVI_out7  (DVI_B[7]));


endmodule


// black box definition for reconfigurable module rm_red
module rm_red(
    rst_n,
    clk,
    out,
    DVI_in0, DVI_in1, DVI_in2, DVI_in3,
    DVI_in4, DVI_in5, DVI_in6, DVI_in7,
    DVI_out0, DVI_out1, DVI_out2, DVI_out3,
    DVI_out4, DVI_out5, DVI_out6, DVI_out7);

    input  rst_n;
    input  clk;
    input  DVI_in0, DVI_in1, DVI_in2, DVI_in3;
    input  DVI_in4, DVI_in5, DVI_in6, DVI_in7;
    output DVI_out0, DVI_out1, DVI_out2, DVI_out3;
    output DVI_out4, DVI_out5, DVI_out6, DVI_out7;
    output out;
endmodule

// black box definition for reconfigurable module rm_green
module rm_green(
    rst_n,
    clk,
    out,
    DVI_in0, DVI_in1, DVI_in2, DVI_in3,
    DVI_in4, DVI_in5, DVI_in6, DVI_in7,
    DVI_out0, DVI_out1, DVI_out2, DVI_out3,
    DVI_out4, DVI_out5, DVI_out6, DVI_out7);

    input  rst_n;
    input  clk;
    input  DVI_in0, DVI_in1, DVI_in2, DVI_in3;
    input  DVI_in4, DVI_in5, DVI_in6, DVI_in7;
    output DVI_out0, DVI_out1, DVI_out2, DVI_out3;
    output DVI_out4, DVI_out5, DVI_out6, DVI_out7;
    output out;
endmodule

// black box definition for reconfigurable module rm_blue
module rm_blue(
    rst_n,
    clk,
    out,
    DVI_in0, DVI_in1, DVI_in2, DVI_in3,
    DVI_in4, DVI_in5, DVI_in6, DVI_in7,
    DVI_out0, DVI_out1, DVI_out2, DVI_out3,
    DVI_out4, DVI_out5, DVI_out6, DVI_out7);

    input  rst_n;
    input  clk;
    input  DVI_in0, DVI_in1, DVI_in2, DVI_in3;
    input  DVI_in4, DVI_in5, DVI_in6, DVI_in7;
    output DVI_out0, DVI_out1, DVI_out2, DVI_out3;
    output DVI_out4, DVI_out5, DVI_out6, DVI_out7;
    output out;
endmodule
