// IBUFDS_DIFF_OUT_INTERMDISABLE: Differential Input Buffer with Differential Output with Input Termination Disable
//                                May only be placed in High Range (HR) Banks
//                                7 Series
// Xilinx HDL Libraries Guide, version 14.5

IBUFDS_DIFF_OUT_INTERMDISABLE  #(
   .DIFF_TERM("FALSE"),     // Differential Termination, "TRUE"/"FALSE"
   .IBUF_LOW_PWR("TRUE"),   // Low power="TRUE", Highest performance="FALSE"
   .IOSTANDARD("DEFAULT"),  // Specify the input I/O standard
   .USE_IBUFDISABLE("TRUE") // Set to "TRUE" to enable IBUFDISABLE feature
) IBUFDS_DIFF_OUT_INTERMDISABLE_inst (
   .O(O),   // Buffer diff_p output
   .OB(OB), // Buffer diff_n output
   .I(I),   // Diff_p buffer input (connect directly to top-level port)
   .IB(IB), // Diff_n buffer input (connect directly to top-level port)
   .IBUFDISABLE(IBUFDISABLE),    // Buffer disable input, low=disable
   .INTERMDISABLE(INTERMDISABLE) // Input Termination Disable
);

// End of IBUFDS_DIFF_OUT_INTERMDISABLE_inst instantiation
