// IBUF_IBUFDISABLE: Single-ended Input Buffer with Disable
//                   7 Series
// Xilinx HDL Libraries Guide, version 14.5

IBUF_IBUFDISABLE #(
   .IBUF_LOW_PWR("TRUE"),   // Low power ("TRUE") vs. performance ("FALSE") for referenced I/O standards 
   .IOSTANDARD("DEFAULT"),  // Specify the input I/O standard
   .USE_IBUFDISABLE("TRUE") // Set to "TRUE" to enable IBUFDISABLE feature
) IBUF_IBUFDISABLE_inst (
   .O(O),                    // Buffer output
   .I(I),                    // Buffer input (connect directly to top-level port)
   .IBUFDISABLE(IBUFDISABLE) // Buffer disable input, low=disable
);
  
// End of IBUF_IBUFDISABLE_inst instantiation
