// IOBUF: Single-ended Bi-directional Buffer
//        Spartan-3
// Xilinx HDL Libraries Guide, version 14.5

IOBUF #(
   .DRIVE(12), // Specify the output drive strength
   .IBUF_DELAY_VALUE("0"),   // Specify the amount of added input delay for the buffer,
                             //  "0"-"16" (Spartan-3A only)
   .IFD_DELAY_VALUE("AUTO"), // Specify the amount of added delay for input register,
                             //  "AUTO", "0"-"8" (Spartan-3A only)
   .IOSTANDARD("DEFAULT"), // Specify the I/O standard
   .SLEW("SLOW") // Specify the output slew rate
) IOBUF_inst (
   .O(O),     // Buffer output
   .IO(IO),   // Buffer inout port (connect directly to top-level port)
   .I(I),     // Buffer input
   .T(T)      // 3-state enable input, high=input, low=output
);
  
// End of IOBUF_inst instantiation
