// SPI_ACCESS: Internal Logic Access to the Serial Peripheral
//             Interface (SPI) PROM Data
//             Spartan-3AN
// Xilinx HDL Libraries Guide, version 14.5

SPI_ACCESS #(
   .SIM_DELAY_TYPE("SCALED"), // "ACCURATE" spec timing delays, "SCALED" shorten delays (faster sim)
   .SIM_DEVICE("3S1400AN"),   // "3S50AN", "3S200AN", "3S400AN", "3S700AN", "3S1400AN"
   .SIM_FACTORY_ID(64'h0),    // Specifies the Pre-programmed factory ID value
   .SIM_MEM_FILE("NONE"),     // Name/location of file containing memory contents
   .SIM_USER_ID(64'h0)        // Specifies the programmed User ID value
) SPI_ACCESS_inst (
   .MISO(MISO),  // Serial output data from SPI PROM
   .CLK(CLK),    // SPI PROM clock input
   .CSB(CSB),    // SPI PROM enable input
   .MOSI(MOSI)   // Serial input data to SPI PROM
);

// End of SPI_ACCESS_inst instantiation
