--------------------------------------------------------------
-- (C) Copyright 2010-2011 Xilinx, Inc. All Rights Reserved.
-- 
-- XILINX, the Xilinx logo, the Brand Window and other 
-- designated brands included herein are trademarks of Xilinx, 
-- Inc. All other trademarks are the property of their 
-- respective owners.
-- 
-- NOTICE OF DISCLAIMER: The information disclosed to you 
-- hereunder (the "Information") is provided "AS-IS" with no 
-- warranty of any kind, express or implied. Xilinx does not 
-- assume any liability arising from your use of the 
-- Information. You are responsible for obtaining any rights 
-- you may require for your use of this Information. Xilinx 
-- reserves the right to make changes, at any time, to the 
-- Information without notice and at its sole discretion. 
-- Xilinx assumes no obligation to correct any errors contained 
-- in the Information or to advise you of any corrections or 
-- updates. Xilinx expressly disclaims any liability in 
-- connection with technical support or assistance that may be 
-- provided to you in connection with the Information. XILINX 
-- MAKES NO OTHER WARRANTIES, WHETHER EXPRESS, IMPLIED, OR 
-- STATUTORY, REGARDING THE INFORMATION, INCLUDING ANY 
-- WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
-- PURPOSE, OR NONINFRINGEMENT OF THIRD-PARTY RIGHTS.
--------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_signed.all;

entity sinegen is
  port
  (
    clk   : in    std_logic;
    reset : in    std_logic;
    sel   : in    std_logic_vector(1 downto 0);
    sine  : out std_logic_vector(19 downto 0)
  );
end sinegen;

architecture virtex of sinegen is

  attribute syn_noprune : boolean;
  attribute syn_noprune of virtex : architecture is TRUE;

  component sine_high
    port
    (
      CLK      : in    std_logic;
      PHASE_IN : in    std_logic_vector(9 downto 0);
      SINE     : out std_logic_vector(19 downto 0)
    );
  end component;

  component sine_mid
    port
    (
      CLK      : in  std_logic;
      PHASE_IN : in  std_logic_vector(7 downto 0);
      SINE     : out std_logic_vector(17 downto 0)
    );
  end component;

  component sine_low
    port
    (
      CLK      : in  std_logic;
      PHASE_IN : in  std_logic_vector(5 downto 0);
      SINE     : out std_logic_vector(15 downto 0)
    );
  end component;

  attribute syn_black_box : boolean;
  attribute syn_black_box of sine_high: component is true;
  attribute syn_black_box of sine_mid: component is true;
  attribute syn_black_box of sine_low: component is true;

  signal count    : std_logic_vector(9 downto 0) := (others => '0');

  signal sine_h   : std_logic_vector(19 downto 0);
  signal sine_m   : std_logic_vector(17 downto 0);
  signal sine_l   : std_logic_vector(15 downto 0);
  signal sine_h_dly   : std_logic_vector(19 downto 0);
  signal sine_m_plus_l   : std_logic_vector(19 downto 0);
  signal sine_h_minus_m_plus_l : std_logic_vector(19 downto 0); 
  
begin

  process (clk)
  begin
    if (rising_edge(clk)) then
      if (reset = '1') then

        count                 <= (others => '0');
				sine_h_dly            <= (others => '0');
				sine_m_plus_l         <= (others => '0');
				sine_h_minus_m_plus_l <= (others => '0');
        sine                  <= (others => '0');

      else

        count <= count + 1;

        sine_h_dly <= sine_h;
        sine_m_plus_l <= (sine_m(17) & sine_m(17) & sine_m) +
                         (sine_l(15) & sine_l(15) & sine_l(15) & sine_l(15) & sine_l);
        sine_h_minus_m_plus_l <= sine_h_dly - sine_m_plus_l;    
             
        if (sel = "00") then
          sine <= (sine_l(15) & sine_l(15) & sine_l(15) & sine_l(15) & sine_l);
        elsif (sel = "01") then
          sine <= (sine_m(17) & sine_m(17) & sine_m);
        elsif (sel = "10") then
          sine <= sine_h;
        elsif (sel = "11") then
          sine <= sine_h_minus_m_plus_l;
        end if;

      end if;

    end if;
  end process;

  U_SH : sine_high
    port map
    (
      CLK      => clk,
      PHASE_IN => count(9 downto 0),
      SINE     => sine_h
    );

  U_SM : sine_mid
    port map
    (
      CLK      => clk,
      PHASE_IN => count(7 downto 0),
      SINE     => sine_m
    );

  U_SL : sine_low
    port map
    (
      CLK      => clk,
      PHASE_IN => count(5 downto 0),
      SINE     => sine_l
    );

end virtex;
