// DSP48A: DSP Function Block
//         Spartan-3A DSP
// Xilinx HDL Libraries Guide, version 14.5

DSP48A #(
   .A0REG(0), // Enable=1/disable=0 first stage A input pipeline register
   .A1REG(1), // Enable=1/disable=0 second stage A input pipeline register
   .B0REG(0), // Enable=1/disable=0 first stage B input pipeline register
   .B1REG(1), // Enable=1/disable=0 second stage B input pipeline register
   .CARRYINREG(1), // Enable=1/disable=0 CARRYIN input pipeline register
   .CARRYINSEL("CARRYIN"), // Specify carry-in source, "CARRYIN" or "OPMODE5"
   .CREG(1),  // Enable=1/disable=0 C input pipeline register
   .DREG(1),  // Enable=1/disable=0 D pre-adder input pipeline register
   .MREG(1),  // Enable=1/disable=0 M pipeline register
   .OPMODEREG(1), // Enable=1/disable=0 OPMODE input pipeline register
   .PREG(1),  // Enable=1/disable=0 P output pipeline register
   .RSTTYPE("SYNC") // Specify reset type, "SYNC" or "ASYNC"
) DSP48A_inst (
   .BCOUT(BCOUT), // 18-bit B port cascade output
   .CARRYOUT(CARRYOUT), // 1-bit carry output
   .P(P), // 48-bit output
   .PCOUT(PCOUT), // 48-bit cascade output
   .A(A), // 18-bit A data input
   .B(B), // 18-bit B data input (can be connected to fabric or BCOUT of adjacent DSP48A)
   .C(C), // 48-bit C data input
   .CARRYIN(CARRYIN), // 1-bit carry input signal
   .CEA(CEA), // 1-bit active high clock enable input for A input registers
   .CEB(CEB), // 1-bit active high clock enable input for B input registers
   .CEC(CEC), // 1-bit active high clock enable input for C input registers
   .CECARRYIN(CECARRYIN), // 1-bit active high clock enable input for CARRYIN registers
   .CED(CED), // 1-bit active high clock enable input for D input registers
   .CEM(CEM), // 1-bit active high clock enable input for multiplier registers
   .CEOPMODE(CEOPMODE), // 1-bit active high clock enable input for OPMODE registers
   .CEP(CEP), // 1-bit active high clock enable input for P output registers
   .CLK(CLK), // Clock input
   .D(D), // 18-bit B pre-adder data input
   .OPMODE(OPMODE), // 8-bit operation mode input
   .PCIN(PCIN), // 48-bit P cascade input 
   .RSTA(RSTA), // 1-bit reset input for A input pipeline registers
   .RSTB(RSTB), // 1-bit reset input for B input pipeline registers
   .RSTC(RSTC), // 1-bit reset input for C input pipeline registers
   .RSTCARRYIN(RSTCARRYIN), // 1-bit reset input for CARRYIN input pipeline registers
   .RSTD(RSTD), // 1-bit reset input for D input pipeline registers
   .RSTM(RSTM), // 1-bit reset input for M pipeline registers
   .RSTOPMODE(RSTOPMODE), // 1-bit reset input for OPMODE input pipeline registers
   .RSTP(RSTP) // 1-bit reset input for P output pipeline registers
);

// End of DSP48A_inst instantiation
