////////////////////////////////////////////////////////////////////////////////
//   ____  ____ 
//  /   /\/   / 
// /___/  \  /    Vendor: Xilinx 
// \   \   \/     Version : 1.5
//  \   \         Application : 7 Series FPGAs Transceivers Wizard 
//  /   /         Filename : rocketio_wrapper_tile_top.v
// /___/   /\     
// \   \  /  \ 
//  \___\/\___\ 
//
//
// Module ROCKETIO_WRAPPER_TILE_top
// Generated by Xilinx 7 Series FPGAs Transceivers Wizard
// 
// 
// (c) Copyright 2010-2011 Xilinx, Inc. All rights reserved.
// 
// This file contains confidential and proprietary information
// of Xilinx, Inc. and is protected under U.S. and
// international copyright and other intellectual property
// laws.
// 
// DISCLAIMER
// This disclaimer is not a license and does not grant any
// rights to the materials distributed herewith. Except as
// otherwise provided in a valid license issued to you by
// Xilinx, and to the maximum extent permitted by applicable
// law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS" AND
// WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES
// AND CONDITIONS, EXPRESS, IMPLIED, OR STATUTORY, INCLUDING
// BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-
// INFRINGEMENT, OR FITNESS FOR ANY PARTICULAR PURPOSE; and
// (2) Xilinx shall not be liable (whether in contract or tort,
// including negligence, or under any other theory of
// liability) for any loss or damage of any kind or nature
// related to, arising under or in connection with these
// materials, including for any direct, or any indirect,
// special, incidental, or consequential loss or damage
// (including loss of data, profits, goodwill, or any type of
// loss or damage suffered as a result of any action brought
// by a third party) even if such damage or loss was
// reasonably foreseeable or Xilinx had been advised of the
// possibility of the same.
// 
// CRITICAL APPLICATIONS
// Xilinx products are not designed or intended to be fail-
// safe, or for use in any application requiring fail-safe
// performance, such as life-support or safety devices or
// systems, Class III medical devices, nuclear facilities,
// applications related to the deployment of airbags, or any
// other applications that could lead to death, personal
// injury, or severe property or environmental damage
// (individually and collectively, "Critical
// Applications"). Customer assumes the sole risk and
// liability of any use of Xilinx products in Critical
// Applications, subject only to applicable laws and
// regulations governing limitations on product liability.
// 
// THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS
// PART OF THIS FILE AT ALL TIMES. 


`timescale 1ns / 1ps
`define DLY #1


//***********************************Entity Declaration************************

module mgtTop # // ROCKETIO_WRAPPER_TILE_top #
(
    parameter EXAMPLE_CONFIG_INDEPENDENT_LANES     =   1,//configuration for frame gen and check
    parameter EXAMPLE_LANE_WITH_START_CHAR         =   0,   // specifies lane with unique start frame char
    parameter EXAMPLE_WORDS_IN_BRAM                =   512, // specifies amount of data in BRAM
    parameter EXAMPLE_SIM_GTRESET_SPEEDUP          =   "TRUE",   // simulation setting for GT SecureIP model
    parameter EXAMPLE_USE_CHIPSCOPE                =   0    // Set to 1 to use Chipscope to drive resets
)
(
    input wire  Q0_CLK0_GTREFCLK_PAD_N_IN,
    input wire  Q0_CLK0_GTREFCLK_PAD_P_IN,
    input wire  Q0_CLK1_GTREFCLK_PAD_N_IN,
    input wire  Q0_CLK1_GTREFCLK_PAD_P_IN,
    input wire  Q1_CLK0_GTREFCLK_PAD_N_IN,
    input wire  Q1_CLK0_GTREFCLK_PAD_P_IN,
    input wire  Q1_CLK1_GTREFCLK_PAD_N_IN,
    input wire  Q1_CLK1_GTREFCLK_PAD_P_IN,
    input wire  SYSCLK_IN,
    input wire  GTTXRESET_IN,
    input wire  GTRXRESET_IN,
    output wire TRACK_DATA_OUT,
    input  wire [7:0]   RXN_IN,
    input  wire [7:0]   RXP_IN,
    output wire [7:0]   TXN_OUT,
    output wire [7:0]   TXP_OUT,
	// Wishbone Interface
    input wire          wb_clk,
    input wire          wb_reset,
    input wire          wb_stb_i,
    output reg [31:0]   wb_dat_o,
    input wire [31:0]   wb_dat_i,
    output reg          wb_ack_o,
    input wire [31:0]   wb_adr_i,
    input wire          wb_we_i,
    input wire          wb_cyc_i,
    input wire [3:0]    wb_sel_i,
    output wire         wb_err_o,
    output reg         wb_rty_o
);


//************************** Register Declarations ****************************

    reg             gt0_txuserrdy_r;
    reg             gt0_txresetdone_r;
    reg             gt0_txresetdone_r2;
    reg             gt0_rxuserrdy_r;
    reg             gt0_rxresetdone_r;
    reg             gt0_rxresetdone_r2;
    reg             gt0_rxresetdone_r3;

    reg             gt1_txuserrdy_r;
    reg             gt1_txresetdone_r;
    reg             gt1_txresetdone_r2;
    reg             gt1_rxuserrdy_r;
    reg             gt1_rxresetdone_r;
    reg             gt1_rxresetdone_r2;
    reg             gt1_rxresetdone_r3;

    reg             gt2_txuserrdy_r;
    reg             gt2_txresetdone_r;
    reg             gt2_txresetdone_r2;
    reg             gt2_rxuserrdy_r;
    reg             gt2_rxresetdone_r;
    reg             gt2_rxresetdone_r2;
    reg             gt2_rxresetdone_r3;

    reg             gt3_txuserrdy_r;
    reg             gt3_txresetdone_r;
    reg             gt3_txresetdone_r2;
    reg             gt3_rxuserrdy_r;
    reg             gt3_rxresetdone_r;
    reg             gt3_rxresetdone_r2;
    reg             gt3_rxresetdone_r3;

    reg             gt4_txuserrdy_r;
    reg             gt4_txresetdone_r;
    reg             gt4_txresetdone_r2;
    reg             gt4_rxuserrdy_r;
    reg             gt4_rxresetdone_r;
    reg             gt4_rxresetdone_r2;
    reg             gt4_rxresetdone_r3;

    reg             gt5_txuserrdy_r;
    reg             gt5_txresetdone_r;
    reg             gt5_txresetdone_r2;
    reg             gt5_rxuserrdy_r;
    reg             gt5_rxresetdone_r;
    reg             gt5_rxresetdone_r2;
    reg             gt5_rxresetdone_r3;

    reg             gt6_txuserrdy_r;
    reg             gt6_txresetdone_r;
    reg             gt6_txresetdone_r2;
    reg             gt6_rxuserrdy_r;
    reg             gt6_rxresetdone_r;
    reg             gt6_rxresetdone_r2;
    reg             gt6_rxresetdone_r3;

    reg             gt7_txuserrdy_r;
    reg             gt7_txresetdone_r;
    reg             gt7_txresetdone_r2;
    reg             gt7_rxuserrdy_r;
    reg             gt7_rxresetdone_r;
    reg             gt7_rxresetdone_r2;
    reg             gt7_rxresetdone_r3;



//**************************** Wire Declarations ******************************//
    //------------------------ GT Wrapper Wires ------------------------------
    //________________________________________________________________________
    //________________________________________________________________________
    //GT0   (X0Y0)
    //------------------------------ Channel PLL -------------------------------
    wire            gt0_cpllfbclklost_i;
    wire            gt0_cplllock_i;
    wire            gt0_cpllrefclklost_i;
    wire            gt0_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt0_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt0_loopback_i;
    wire    [1:0]   gt0_rxpd_i;
    wire    [1:0]   gt0_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt0_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt0_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt0_rxbyteisaligned_i;
    wire            gt0_rxbyterealign_i;
    wire            gt0_rxcommadet_i;
    wire            gt0_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt0_gtrxreset_i;
    wire    [15:0]  gt0_rxdata_i;
    wire            gt0_rxoutclk_i;
    wire            gt0_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt0_gtxrxn_i;
    wire            gt0_gtxrxp_i;
    wire            gt0_rxcdrlock_i;
    wire            gt0_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt0_rxbufreset_i;
    wire    [2:0]   gt0_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt0_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt0_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt0_txprecursorinv_i;
    wire            gt0_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt0_gttxreset_i;
    wire    [15:0]  gt0_txdata_i;
    wire            gt0_txoutclk_i;
    wire            gt0_txoutclkfabric_i;
    wire            gt0_txoutclkpcs_i;
    wire            gt0_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt0_gtxtxn_i;
    wire            gt0_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt0_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt0_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT1   (X0Y1)
    //------------------------------ Channel PLL -------------------------------
    wire            gt1_cpllfbclklost_i;
    wire            gt1_cplllock_i;
    wire            gt1_cpllrefclklost_i;
    wire            gt1_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt1_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt1_loopback_i;
    wire    [1:0]   gt1_rxpd_i;
    wire    [1:0]   gt1_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt1_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt1_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt1_rxbyteisaligned_i;
    wire            gt1_rxbyterealign_i;
    wire            gt1_rxcommadet_i;
    wire            gt1_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt1_gtrxreset_i;
    wire    [15:0]  gt1_rxdata_i;
    wire            gt1_rxoutclk_i;
    wire            gt1_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt1_gtxrxn_i;
    wire            gt1_gtxrxp_i;
    wire            gt1_rxcdrlock_i;
    wire            gt1_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt1_rxbufreset_i;
    wire    [2:0]   gt1_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt1_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt1_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt1_txprecursorinv_i;
    wire            gt1_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt1_gttxreset_i;
    wire    [15:0]  gt1_txdata_i;
    wire            gt1_txoutclk_i;
    wire            gt1_txoutclkfabric_i;
    wire            gt1_txoutclkpcs_i;
    wire            gt1_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt1_gtxtxn_i;
    wire            gt1_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt1_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt1_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT2   (X0Y2)
    //------------------------------ Channel PLL -------------------------------
    wire            gt2_cpllfbclklost_i;
    wire            gt2_cplllock_i;
    wire            gt2_cpllrefclklost_i;
    wire            gt2_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt2_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt2_loopback_i;
    wire    [1:0]   gt2_rxpd_i;
    wire    [1:0]   gt2_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt2_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt2_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt2_rxbyteisaligned_i;
    wire            gt2_rxbyterealign_i;
    wire            gt2_rxcommadet_i;
    wire            gt2_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt2_gtrxreset_i;
    wire    [15:0]  gt2_rxdata_i;
    wire            gt2_rxoutclk_i;
    wire            gt2_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt2_gtxrxn_i;
    wire            gt2_gtxrxp_i;
    wire            gt2_rxcdrlock_i;
    wire            gt2_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt2_rxbufreset_i;
    wire    [2:0]   gt2_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt2_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt2_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt2_txprecursorinv_i;
    wire            gt2_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt2_gttxreset_i;
    wire    [15:0]  gt2_txdata_i;
    wire            gt2_txoutclk_i;
    wire            gt2_txoutclkfabric_i;
    wire            gt2_txoutclkpcs_i;
    wire            gt2_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt2_gtxtxn_i;
    wire            gt2_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt2_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt2_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT3   (X0Y3)
    //------------------------------ Channel PLL -------------------------------
    wire            gt3_cpllfbclklost_i;
    wire            gt3_cplllock_i;
    wire            gt3_cpllrefclklost_i;
    wire            gt3_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt3_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt3_loopback_i;
    wire    [1:0]   gt3_rxpd_i;
    wire    [1:0]   gt3_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt3_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt3_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt3_rxbyteisaligned_i;
    wire            gt3_rxbyterealign_i;
    wire            gt3_rxcommadet_i;
    wire            gt3_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt3_gtrxreset_i;
    wire    [15:0]  gt3_rxdata_i;
    wire            gt3_rxoutclk_i;
    wire            gt3_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt3_gtxrxn_i;
    wire            gt3_gtxrxp_i;
    wire            gt3_rxcdrlock_i;
    wire            gt3_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt3_rxbufreset_i;
    wire    [2:0]   gt3_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt3_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt3_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt3_txprecursorinv_i;
    wire            gt3_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt3_gttxreset_i;
    wire    [15:0]  gt3_txdata_i;
    wire            gt3_txoutclk_i;
    wire            gt3_txoutclkfabric_i;
    wire            gt3_txoutclkpcs_i;
    wire            gt3_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt3_gtxtxn_i;
    wire            gt3_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt3_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt3_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT4   (X0Y4)
    //------------------------------ Channel PLL -------------------------------
    wire            gt4_cpllfbclklost_i;
    wire            gt4_cplllock_i;
    wire            gt4_cpllrefclklost_i;
    wire            gt4_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt4_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt4_loopback_i;
    wire    [1:0]   gt4_rxpd_i;
    wire    [1:0]   gt4_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt4_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt4_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt4_rxbyteisaligned_i;
    wire            gt4_rxbyterealign_i;
    wire            gt4_rxcommadet_i;
    wire            gt4_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt4_gtrxreset_i;
    wire    [15:0]  gt4_rxdata_i;
    wire            gt4_rxoutclk_i;
    wire            gt4_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt4_gtxrxn_i;
    wire            gt4_gtxrxp_i;
    wire            gt4_rxcdrlock_i;
    wire            gt4_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt4_rxbufreset_i;
    wire    [2:0]   gt4_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt4_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt4_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt4_txprecursorinv_i;
    wire            gt4_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt4_gttxreset_i;
    wire    [15:0]  gt4_txdata_i;
    wire            gt4_txoutclk_i;
    wire            gt4_txoutclkfabric_i;
    wire            gt4_txoutclkpcs_i;
    wire            gt4_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt4_gtxtxn_i;
    wire            gt4_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt4_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt4_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT5   (X0Y5)
    //------------------------------ Channel PLL -------------------------------
    wire            gt5_cpllfbclklost_i;
    wire            gt5_cplllock_i;
    wire            gt5_cpllrefclklost_i;
    wire            gt5_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt5_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt5_loopback_i;
    wire    [1:0]   gt5_rxpd_i;
    wire    [1:0]   gt5_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt5_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt5_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt5_rxbyteisaligned_i;
    wire            gt5_rxbyterealign_i;
    wire            gt5_rxcommadet_i;
    wire            gt5_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt5_gtrxreset_i;
    wire    [15:0]  gt5_rxdata_i;
    wire            gt5_rxoutclk_i;
    wire            gt5_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt5_gtxrxn_i;
    wire            gt5_gtxrxp_i;
    wire            gt5_rxcdrlock_i;
    wire            gt5_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt5_rxbufreset_i;
    wire    [2:0]   gt5_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt5_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt5_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt5_txprecursorinv_i;
    wire            gt5_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt5_gttxreset_i;
    wire    [15:0]  gt5_txdata_i;
    wire            gt5_txoutclk_i;
    wire            gt5_txoutclkfabric_i;
    wire            gt5_txoutclkpcs_i;
    wire            gt5_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt5_gtxtxn_i;
    wire            gt5_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt5_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt5_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT6   (X0Y6)
    //------------------------------ Channel PLL -------------------------------
    wire            gt6_cpllfbclklost_i;
    wire            gt6_cplllock_i;
    wire            gt6_cpllrefclklost_i;
    wire            gt6_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt6_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt6_loopback_i;
    wire    [1:0]   gt6_rxpd_i;
    wire    [1:0]   gt6_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt6_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt6_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt6_rxbyteisaligned_i;
    wire            gt6_rxbyterealign_i;
    wire            gt6_rxcommadet_i;
    wire            gt6_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt6_gtrxreset_i;
    wire    [15:0]  gt6_rxdata_i;
    wire            gt6_rxoutclk_i;
    wire            gt6_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt6_gtxrxn_i;
    wire            gt6_gtxrxp_i;
    wire            gt6_rxcdrlock_i;
    wire            gt6_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt6_rxbufreset_i;
    wire    [2:0]   gt6_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt6_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt6_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt6_txprecursorinv_i;
    wire            gt6_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt6_gttxreset_i;
    wire    [15:0]  gt6_txdata_i;
    wire            gt6_txoutclk_i;
    wire            gt6_txoutclkfabric_i;
    wire            gt6_txoutclkpcs_i;
    wire            gt6_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt6_gtxtxn_i;
    wire            gt6_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt6_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt6_txresetdone_i;

    //________________________________________________________________________
    //________________________________________________________________________
    //GT7   (X0Y7)
    //------------------------------ Channel PLL -------------------------------
    wire            gt7_cpllfbclklost_i;
    wire            gt7_cplllock_i;
    wire            gt7_cpllrefclklost_i;
    wire            gt7_cpllreset_i;
    //----------------------------- Eye Scan Ports -----------------------------
    wire            gt7_eyescandataerror_i;
    //---------------------- Loopback and Powerdown Ports ----------------------
    wire    [2:0]   gt7_loopback_i;
    wire    [1:0]   gt7_rxpd_i;
    wire    [1:0]   gt7_txpd_i;
    //----------------------------- Receive Ports ------------------------------
    wire            gt7_rxuserrdy_i;
    //----------------- Receive Ports - Clock Correction Ports -----------------
    wire    [1:0]   gt7_rxclkcorcnt_i;
    //------------- Receive Ports - Comma Detection and Alignment --------------
    wire            gt7_rxbyteisaligned_i;
    wire            gt7_rxbyterealign_i;
    wire            gt7_rxcommadet_i;
    wire            gt7_rxslide_i;
    //----------------- Receive Ports - RX Data Path interface -----------------
    wire            gt7_gtrxreset_i;
    wire    [15:0]  gt7_rxdata_i;
    wire            gt7_rxoutclk_i;
    wire            gt7_rxpcsreset_i;
    //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
    wire            gt7_gtxrxn_i;
    wire            gt7_gtxrxp_i;
    wire            gt7_rxcdrlock_i;
    wire            gt7_rxelecidle_i;
    //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
    wire            gt7_rxbufreset_i;
    wire    [2:0]   gt7_rxbufstatus_i;
    //---------------------- Receive Ports - RX PLL Ports ----------------------
    wire            gt7_rxresetdone_i;
    //------------ Receive Ports - RX Pipe Control for PCI Express -------------
    wire            gt7_rxvalid_i;
    //----------------------------- Transmit Ports -----------------------------
    wire            gt7_txprecursorinv_i;
    wire            gt7_txuserrdy_i;
    //---------------- Transmit Ports - TX Data Path interface -----------------
    wire            gt7_gttxreset_i;
    wire    [15:0]  gt7_txdata_i;
    wire            gt7_txoutclk_i;
    wire            gt7_txoutclkfabric_i;
    wire            gt7_txoutclkpcs_i;
    wire            gt7_txpcsreset_i;
    //-------------- Transmit Ports - TX Driver and OOB signaling --------------
    wire            gt7_gtxtxn_i;
    wire            gt7_gtxtxp_i;
    //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
    wire    [1:0]   gt7_txbufstatus_i;
    //--------------------- Transmit Ports - TX PLL Ports ----------------------
    wire            gt7_txresetdone_i;


    //----------------------------- Global Signals -----------------------------

    wire            drpclk_in_i;
    wire            gt0_tx_system_reset_c;
    wire            gt0_rx_system_reset_c;
    wire            gt1_tx_system_reset_c;
    wire            gt1_rx_system_reset_c;
    wire            gt2_tx_system_reset_c;
    wire            gt2_rx_system_reset_c;
    wire            gt3_tx_system_reset_c;
    wire            gt3_rx_system_reset_c;
    wire            gt4_tx_system_reset_c;
    wire            gt4_rx_system_reset_c;
    wire            gt5_tx_system_reset_c;
    wire            gt5_rx_system_reset_c;
    wire            gt6_tx_system_reset_c;
    wire            gt6_rx_system_reset_c;
    wire            gt7_tx_system_reset_c;
    wire            gt7_rx_system_reset_c;
    wire            tied_to_ground_i;
    wire    [63:0]  tied_to_ground_vec_i;
    wire            tied_to_vcc_i;
    wire    [7:0]   tied_to_vcc_vec_i;

     //--------------------------- User Clocks ---------------------------------
    wire            gt0_txusrclk_i; 
    wire            gt0_txusrclk2_i; 
    wire            gt0_txclk_lock_out_i;
    wire            gt0_rxusrclk_i; 
    wire            gt0_rxusrclk2_i; 
    wire            gt0_rxclk_lock_out_i; 
    wire            gt1_txusrclk_i; 
    wire            gt1_txusrclk2_i; 
    wire            gt1_txclk_lock_out_i;
    wire            gt1_rxusrclk_i; 
    wire            gt1_rxusrclk2_i; 
    wire            gt1_rxclk_lock_out_i; 
    wire            gt2_txusrclk_i; 
    wire            gt2_txusrclk2_i; 
    wire            gt2_txclk_lock_out_i;
    wire            gt2_rxusrclk_i; 
    wire            gt2_rxusrclk2_i; 
    wire            gt2_rxclk_lock_out_i; 
    wire            gt3_txusrclk_i; 
    wire            gt3_txusrclk2_i; 
    wire            gt3_txclk_lock_out_i;
    wire            gt3_rxusrclk_i; 
    wire            gt3_rxusrclk2_i; 
    wire            gt3_rxclk_lock_out_i; 
    wire            gt4_txusrclk_i; 
    wire            gt4_txusrclk2_i; 
    wire            gt4_txclk_lock_out_i;
    wire            gt4_rxusrclk_i; 
    wire            gt4_rxusrclk2_i; 
    wire            gt4_rxclk_lock_out_i; 
    wire            gt5_txusrclk_i; 
    wire            gt5_txusrclk2_i; 
    wire            gt5_txclk_lock_out_i;
    wire            gt5_rxusrclk_i; 
    wire            gt5_rxusrclk2_i; 
    wire            gt5_rxclk_lock_out_i; 
    wire            gt6_txusrclk_i; 
    wire            gt6_txusrclk2_i; 
    wire            gt6_txclk_lock_out_i;
    wire            gt6_rxusrclk_i; 
    wire            gt6_rxusrclk2_i; 
    wire            gt6_rxclk_lock_out_i; 
    wire            gt7_txusrclk_i; 
    wire            gt7_txusrclk2_i; 
    wire            gt7_txclk_lock_out_i;
    wire            gt7_rxusrclk_i; 
    wire            gt7_rxusrclk2_i; 
    wire            gt7_rxclk_lock_out_i; 
 
    //--------------------------- Reference Clocks ----------------------------
    
    wire            q0_clk0_refclk_i;
    
    wire            q0_clk1_refclk_i;
    
    wire            q1_clk0_refclk_i;
    
    wire            q1_clk1_refclk_i;

    //--------------------- Frame check/gen Module Signals --------------------
    wire            gt0_matchn_i;
    
    wire    [5:0]   gt0_txcharisk_float_i;
   
    wire    [15:0]  gt0_txdata_float16_i;
    wire    [47:0]  gt0_txdata_float_i;
    
    
    wire            gt0_block_sync_i;
    wire            gt0_track_data_i;
    wire    [7:0]   gt0_error_count_i;
    wire            gt0_frame_check_reset_i;
    wire            gt0_inc_in_i;
    wire            gt0_inc_out_i;
    wire    [15:0]  gt0_unscrambled_data_i;

    wire            gt1_matchn_i;
    
    wire    [5:0]   gt1_txcharisk_float_i;
   
    wire    [15:0]  gt1_txdata_float16_i;
    wire    [47:0]  gt1_txdata_float_i;
    
    
    wire            gt1_block_sync_i;
    wire            gt1_track_data_i;
    wire    [7:0]   gt1_error_count_i;
    wire            gt1_frame_check_reset_i;
    wire            gt1_inc_in_i;
    wire            gt1_inc_out_i;
    wire    [15:0]  gt1_unscrambled_data_i;

    wire            gt2_matchn_i;
    
    wire    [5:0]   gt2_txcharisk_float_i;
   
    wire    [15:0]  gt2_txdata_float16_i;
    wire    [47:0]  gt2_txdata_float_i;
    
    
    wire            gt2_block_sync_i;
    wire            gt2_track_data_i;
    wire    [7:0]   gt2_error_count_i;
    wire            gt2_frame_check_reset_i;
    wire            gt2_inc_in_i;
    wire            gt2_inc_out_i;
    wire    [15:0]  gt2_unscrambled_data_i;

    wire            gt3_matchn_i;
    
    wire    [5:0]   gt3_txcharisk_float_i;
   
    wire    [15:0]  gt3_txdata_float16_i;
    wire    [47:0]  gt3_txdata_float_i;
    
    
    wire            gt3_block_sync_i;
    wire            gt3_track_data_i;
    wire    [7:0]   gt3_error_count_i;
    wire            gt3_frame_check_reset_i;
    wire            gt3_inc_in_i;
    wire            gt3_inc_out_i;
    wire    [15:0]  gt3_unscrambled_data_i;

    wire            gt4_matchn_i;
    
    wire    [5:0]   gt4_txcharisk_float_i;
   
    wire    [15:0]  gt4_txdata_float16_i;
    wire    [47:0]  gt4_txdata_float_i;
    
    
    wire            gt4_block_sync_i;
    wire            gt4_track_data_i;
    wire    [7:0]   gt4_error_count_i;
    wire            gt4_frame_check_reset_i;
    wire            gt4_inc_in_i;
    wire            gt4_inc_out_i;
    wire    [15:0]  gt4_unscrambled_data_i;

    wire            gt5_matchn_i;
    
    wire    [5:0]   gt5_txcharisk_float_i;
   
    wire    [15:0]  gt5_txdata_float16_i;
    wire    [47:0]  gt5_txdata_float_i;
    
    
    wire            gt5_block_sync_i;
    wire            gt5_track_data_i;
    wire    [7:0]   gt5_error_count_i;
    wire            gt5_frame_check_reset_i;
    wire            gt5_inc_in_i;
    wire            gt5_inc_out_i;
    wire    [15:0]  gt5_unscrambled_data_i;

    wire            gt6_matchn_i;
    
    wire    [5:0]   gt6_txcharisk_float_i;
   
    wire    [15:0]  gt6_txdata_float16_i;
    wire    [47:0]  gt6_txdata_float_i;
    
    
    wire            gt6_block_sync_i;
    wire            gt6_track_data_i;
    wire    [7:0]   gt6_error_count_i;
    wire            gt6_frame_check_reset_i;
    wire            gt6_inc_in_i;
    wire            gt6_inc_out_i;
    wire    [15:0]  gt6_unscrambled_data_i;

    wire            gt7_matchn_i;
    
    wire    [5:0]   gt7_txcharisk_float_i;
   
    wire    [15:0]  gt7_txdata_float16_i;
    wire    [47:0]  gt7_txdata_float_i;
    
    
    wire            gt7_block_sync_i;
    wire            gt7_track_data_i;
    wire    [7:0]   gt7_error_count_i;
    wire            gt7_frame_check_reset_i;
    wire            gt7_inc_in_i;
    wire            gt7_inc_out_i;
    wire    [15:0]  gt7_unscrambled_data_i;

    wire            reset_on_data_error_i;
    wire            track_data_out_i;
  

    //--------------------- Chipscope Signals ---------------------------------

    wire    [35:0]  tx_data_vio_control_i;
    wire    [35:0]  rx_data_vio_control_i;
    wire    [35:0]  shared_vio_control_i;
    wire    [35:0]  ila_control_i;
    wire    [31:0]  tx_data_vio_async_in_i;
    wire    [31:0]  tx_data_vio_sync_in_i;
    wire    [31:0]  tx_data_vio_async_out_i;
    wire    [31:0]  tx_data_vio_sync_out_i;
    wire    [31:0]  rx_data_vio_async_in_i;
    wire    [31:0]  rx_data_vio_sync_in_i;
    wire    [31:0]  rx_data_vio_async_out_i;
    wire    [31:0]  rx_data_vio_sync_out_i;
    wire    [31:0]  shared_vio_in_i;
    wire    [31:0]  shared_vio_out_i;
    wire    [163:0] ila_in_i;

    wire    [31:0]  gt0_tx_data_vio_async_in_i;
    wire    [31:0]  gt0_tx_data_vio_sync_in_i;
    wire    [31:0]  gt0_tx_data_vio_async_out_i;
    wire    [31:0]  gt0_tx_data_vio_sync_out_i;
    wire    [31:0]  gt0_rx_data_vio_async_in_i;
    wire    [31:0]  gt0_rx_data_vio_sync_in_i;
    wire    [31:0]  gt0_rx_data_vio_async_out_i;
    wire    [31:0]  gt0_rx_data_vio_sync_out_i;
    wire    [163:0] gt0_ila_in_i;

    wire    [31:0]  gt1_tx_data_vio_async_in_i;
    wire    [31:0]  gt1_tx_data_vio_sync_in_i;
    wire    [31:0]  gt1_tx_data_vio_async_out_i;
    wire    [31:0]  gt1_tx_data_vio_sync_out_i;
    wire    [31:0]  gt1_rx_data_vio_async_in_i;
    wire    [31:0]  gt1_rx_data_vio_sync_in_i;
    wire    [31:0]  gt1_rx_data_vio_async_out_i;
    wire    [31:0]  gt1_rx_data_vio_sync_out_i;
    wire    [163:0] gt1_ila_in_i;

    wire    [31:0]  gt2_tx_data_vio_async_in_i;
    wire    [31:0]  gt2_tx_data_vio_sync_in_i;
    wire    [31:0]  gt2_tx_data_vio_async_out_i;
    wire    [31:0]  gt2_tx_data_vio_sync_out_i;
    wire    [31:0]  gt2_rx_data_vio_async_in_i;
    wire    [31:0]  gt2_rx_data_vio_sync_in_i;
    wire    [31:0]  gt2_rx_data_vio_async_out_i;
    wire    [31:0]  gt2_rx_data_vio_sync_out_i;
    wire    [163:0] gt2_ila_in_i;

    wire    [31:0]  gt3_tx_data_vio_async_in_i;
    wire    [31:0]  gt3_tx_data_vio_sync_in_i;
    wire    [31:0]  gt3_tx_data_vio_async_out_i;
    wire    [31:0]  gt3_tx_data_vio_sync_out_i;
    wire    [31:0]  gt3_rx_data_vio_async_in_i;
    wire    [31:0]  gt3_rx_data_vio_sync_in_i;
    wire    [31:0]  gt3_rx_data_vio_async_out_i;
    wire    [31:0]  gt3_rx_data_vio_sync_out_i;
    wire    [163:0] gt3_ila_in_i;

    wire    [31:0]  gt4_tx_data_vio_async_in_i;
    wire    [31:0]  gt4_tx_data_vio_sync_in_i;
    wire    [31:0]  gt4_tx_data_vio_async_out_i;
    wire    [31:0]  gt4_tx_data_vio_sync_out_i;
    wire    [31:0]  gt4_rx_data_vio_async_in_i;
    wire    [31:0]  gt4_rx_data_vio_sync_in_i;
    wire    [31:0]  gt4_rx_data_vio_async_out_i;
    wire    [31:0]  gt4_rx_data_vio_sync_out_i;
    wire    [163:0] gt4_ila_in_i;

    wire    [31:0]  gt5_tx_data_vio_async_in_i;
    wire    [31:0]  gt5_tx_data_vio_sync_in_i;
    wire    [31:0]  gt5_tx_data_vio_async_out_i;
    wire    [31:0]  gt5_tx_data_vio_sync_out_i;
    wire    [31:0]  gt5_rx_data_vio_async_in_i;
    wire    [31:0]  gt5_rx_data_vio_sync_in_i;
    wire    [31:0]  gt5_rx_data_vio_async_out_i;
    wire    [31:0]  gt5_rx_data_vio_sync_out_i;
    wire    [163:0] gt5_ila_in_i;

    wire    [31:0]  gt6_tx_data_vio_async_in_i;
    wire    [31:0]  gt6_tx_data_vio_sync_in_i;
    wire    [31:0]  gt6_tx_data_vio_async_out_i;
    wire    [31:0]  gt6_tx_data_vio_sync_out_i;
    wire    [31:0]  gt6_rx_data_vio_async_in_i;
    wire    [31:0]  gt6_rx_data_vio_sync_in_i;
    wire    [31:0]  gt6_rx_data_vio_async_out_i;
    wire    [31:0]  gt6_rx_data_vio_sync_out_i;
    wire    [163:0] gt6_ila_in_i;

    wire    [31:0]  gt7_tx_data_vio_async_in_i;
    wire    [31:0]  gt7_tx_data_vio_sync_in_i;
    wire    [31:0]  gt7_tx_data_vio_async_out_i;
    wire    [31:0]  gt7_tx_data_vio_sync_out_i;
    wire    [31:0]  gt7_rx_data_vio_async_in_i;
    wire    [31:0]  gt7_rx_data_vio_sync_in_i;
    wire    [31:0]  gt7_rx_data_vio_async_out_i;
    wire    [31:0]  gt7_rx_data_vio_sync_out_i;
    wire    [163:0] gt7_ila_in_i;

// WishBone interface 
    reg  [127:0]    data_o;
    reg  [31:0]     control_reg;
    reg  [127:0]    data_reg;
    reg  [127:0]    data_i;
    reg             ready_i;
    wire            gttxreset_i;
    wire            gtrxreset_i;
    wire    [2:0]   mux_sel_i;
    wire            user_tx_reset_i;
    wire            user_rx_reset_i;
    wire            tx_vio_clk_i;
    wire            tx_vio_clk_mux_out_i;    
    wire            rx_vio_ila_clk_i;
    wire            rx_vio_ila_clk_mux_out_i;
    wire            cpllreset_i;
    
    //--------------------- Wishbone Interface ---------------
    always @(posedge wb_clk or posedge wb_reset) begin
      if(wb_reset==1) begin
        wb_ack_o    <= #1 0;
        wb_dat_o    <= #1 0;
        control_reg <= #1 32'h0;
        data_reg    <= #1 127'h0;
        data_o      <= #1 127'h0;
      end
      else begin
        if(ready_i) begin
          control_reg[1] <= #1 1'b1;  
          data_reg <= #1 data_i;
        end
        else if(wb_stb_i && wb_cyc_i && wb_we_i && ~wb_ack_o) begin
          wb_ack_o<=#1 1;
         case(wb_adr_i[7:0])
             8'h0: begin
                   //Writing control register
                   control_reg<= #1 wb_dat_i;
                   end
             8'h4: begin
                   data_o[127:96]<= #1 wb_dat_i;
                   end                 
             8'h8: begin
                   data_o[95:64]<= #1 wb_dat_i;
                   end                 
			 8'hC: begin
                   data_o[63:32]<= #1 wb_dat_i;
                   end                 
             8'h10:begin
                   data_o[31:0]<= #1 wb_dat_i;
                   end                 
		 endcase
        end
        else if(wb_stb_i && wb_cyc_i && ~wb_we_i && ~wb_ack_o) begin
          wb_ack_o<=#1 1;
          case(wb_adr_i[7:0])
              8'h0: begin
                    wb_dat_o<= #1 control_reg;
                    control_reg[1]<=1'b0;
                    end
             8'h24: begin
                    wb_dat_o<= #1 data_reg[127:96];
                    end
             8'h28: begin
                    wb_dat_o<= #1 data_reg[95:64];
                    end
             8'h2C: begin
                    wb_dat_o<= #1 data_reg[63:32];
                    end
             8'h30: begin
                    wb_dat_o<= #1 data_reg[31:0];
                    end
          endcase
       end
       else begin
          wb_ack_o<=#1 0;
          control_reg[0]<= #1 1'b0;
       end
     end
    end

// Xilinx add in an output register
always @(posedge wb_clk) begin
    //wb_rty_o <= tile0_rxlossofsync0_i & tile0_rxlossofsync1_i & tile1_rxlossofsync0_i & tile1_rxlossofsync1_i & tile2_rxlossofsync0_i & tile2_rxlossofsync1_i & tile3_rxlossofsync0_i & tile3_rxlossofsync1_i ;
	wb_rty_o <= gt0_cpllrefclklost_i & gt1_cpllrefclklost_i & gt2_cpllrefclklost_i & gt3_cpllrefclklost_i &
				gt4_cpllrefclklost_i & gt5_cpllrefclklost_i & gt6_cpllrefclklost_i & gt7_cpllrefclklost_i;
end    

//**************************** Main Body of GT Code *******************************

    //  Static signal Assigments    
    assign tied_to_ground_i             = 1'b0;
    assign tied_to_ground_vec_i         = 64'h0000000000000000;
    assign tied_to_vcc_i                = 1'b1;
    assign tied_to_vcc_vec_i            = 8'hff;


    ROCKETIO_WRAPPER_TILE_GT_USRCLK_SOURCE gt_usrclk_source
   (
    .Q0_CLK0_GTREFCLK_PAD_N_IN  (Q0_CLK0_GTREFCLK_PAD_N_IN),
    .Q0_CLK0_GTREFCLK_PAD_P_IN  (Q0_CLK0_GTREFCLK_PAD_P_IN),
    .Q0_CLK0_GTREFCLK_OUT       (q0_clk0_refclk_i),
    .Q0_CLK1_GTREFCLK_PAD_N_IN  (Q0_CLK1_GTREFCLK_PAD_N_IN),
    .Q0_CLK1_GTREFCLK_PAD_P_IN  (Q0_CLK1_GTREFCLK_PAD_P_IN),
    .Q0_CLK1_GTREFCLK_OUT       (q0_clk1_refclk_i),
    .Q1_CLK0_GTREFCLK_PAD_N_IN  (Q1_CLK0_GTREFCLK_PAD_N_IN),
    .Q1_CLK0_GTREFCLK_PAD_P_IN  (Q1_CLK0_GTREFCLK_PAD_P_IN),
    .Q1_CLK0_GTREFCLK_OUT       (q1_clk0_refclk_i),
    .Q1_CLK1_GTREFCLK_PAD_N_IN  (Q1_CLK1_GTREFCLK_PAD_N_IN),
    .Q1_CLK1_GTREFCLK_PAD_P_IN  (Q1_CLK1_GTREFCLK_PAD_P_IN),
    .Q1_CLK1_GTREFCLK_OUT       (q1_clk1_refclk_i),
 
    .GT0_TXUSRCLK_OUT    (gt0_txusrclk_i),
    .GT0_TXUSRCLK2_OUT   (gt0_txusrclk2_i),
    .GT0_TXOUTCLK_IN     (gt0_txoutclk_i),
    .GT0_RXUSRCLK_OUT    (gt0_rxusrclk_i),
    .GT0_RXUSRCLK2_OUT   (gt0_rxusrclk2_i),
    .GT0_RXOUTCLK_IN     (gt0_rxoutclk_i),
 
    .GT1_TXUSRCLK_OUT    (gt1_txusrclk_i),
    .GT1_TXUSRCLK2_OUT   (gt1_txusrclk2_i),
    .GT1_TXOUTCLK_IN     (gt1_txoutclk_i),
    .GT1_RXUSRCLK_OUT    (gt1_rxusrclk_i),
    .GT1_RXUSRCLK2_OUT   (gt1_rxusrclk2_i),
    .GT1_RXOUTCLK_IN     (gt1_rxoutclk_i),
 
    .GT2_TXUSRCLK_OUT    (gt2_txusrclk_i),
    .GT2_TXUSRCLK2_OUT   (gt2_txusrclk2_i),
    .GT2_TXOUTCLK_IN     (gt2_txoutclk_i),
    .GT2_RXUSRCLK_OUT    (gt2_rxusrclk_i),
    .GT2_RXUSRCLK2_OUT   (gt2_rxusrclk2_i),
    .GT2_RXOUTCLK_IN     (gt2_rxoutclk_i),
 
    .GT3_TXUSRCLK_OUT    (gt3_txusrclk_i),
    .GT3_TXUSRCLK2_OUT   (gt3_txusrclk2_i),
    .GT3_TXOUTCLK_IN     (gt3_txoutclk_i),
    .GT3_RXUSRCLK_OUT    (gt3_rxusrclk_i),
    .GT3_RXUSRCLK2_OUT   (gt3_rxusrclk2_i),
    .GT3_RXOUTCLK_IN     (gt3_rxoutclk_i),
 
    .GT4_TXUSRCLK_OUT    (gt4_txusrclk_i),
    .GT4_TXUSRCLK2_OUT   (gt4_txusrclk2_i),
    .GT4_TXOUTCLK_IN     (gt4_txoutclk_i),
    .GT4_RXUSRCLK_OUT    (gt4_rxusrclk_i),
    .GT4_RXUSRCLK2_OUT   (gt4_rxusrclk2_i),
    .GT4_RXOUTCLK_IN     (gt4_rxoutclk_i),
 
    .GT5_TXUSRCLK_OUT    (gt5_txusrclk_i),
    .GT5_TXUSRCLK2_OUT   (gt5_txusrclk2_i),
    .GT5_TXOUTCLK_IN     (gt5_txoutclk_i),
    .GT5_RXUSRCLK_OUT    (gt5_rxusrclk_i),
    .GT5_RXUSRCLK2_OUT   (gt5_rxusrclk2_i),
    .GT5_RXOUTCLK_IN     (gt5_rxoutclk_i),
 
    .GT6_TXUSRCLK_OUT    (gt6_txusrclk_i),
    .GT6_TXUSRCLK2_OUT   (gt6_txusrclk2_i),
    .GT6_TXOUTCLK_IN     (gt6_txoutclk_i),
    .GT6_RXUSRCLK_OUT    (gt6_rxusrclk_i),
    .GT6_RXUSRCLK2_OUT   (gt6_rxusrclk2_i),
    .GT6_RXOUTCLK_IN     (gt6_rxoutclk_i),
 
    .GT7_TXUSRCLK_OUT    (gt7_txusrclk_i),
    .GT7_TXUSRCLK2_OUT   (gt7_txusrclk2_i),
    .GT7_TXOUTCLK_IN     (gt7_txoutclk_i),
    .GT7_RXUSRCLK_OUT    (gt7_rxusrclk_i),
    .GT7_RXUSRCLK2_OUT   (gt7_rxusrclk2_i),
    .GT7_RXOUTCLK_IN     (gt7_rxoutclk_i),
    .DRPCLK_IN (SYSCLK_IN),
    .DRPCLK_OUT(drpclk_in_i)
);

    //***********************************************************************//
    //                                                                       //
    //--------------------------- The GT Wrapper ----------------------------//
    //                                                                       //
    //***********************************************************************//
    
    // Use the instantiation template in the example directory to add the GT wrapper to your design.
    // In this example, the wrapper is wired up for basic operation with a frame generator and frame 
    // checker. The GTs will reset, then attempt to align and transmit data. If channel bonding is 
    // enabled, bonding should occur after alignment.
    
    ROCKETIO_WRAPPER_TILE #
    (
        .WRAPPER_SIM_GTRESET_SPEEDUP   (EXAMPLE_SIM_GTRESET_SPEEDUP)
    )
    ROCKETIO_WRAPPER_TILE_i
    (
 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT0  (X0Y0)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT0_GTREFCLK0_IN               (q0_clk0_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT0_CPLLFBCLKLOST_OUT          (gt0_cpllfbclklost_i),
        .GT0_CPLLLOCK_OUT               (gt0_cplllock_i),
        .GT0_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT0_CPLLREFCLKLOST_OUT         (gt0_cpllrefclklost_i),
        .GT0_CPLLRESET_IN               (gt0_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT0_EYESCANDATAERROR_OUT       (gt0_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT0_LOOPBACK_IN                (gt0_loopback_i),
        .GT0_RXPD_IN                    (gt0_rxpd_i),
        .GT0_TXPD_IN                    (gt0_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT0_RXUSERRDY_IN               (gt0_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT0_RXCLKCORCNT_OUT            (gt0_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT0_RXBYTEISALIGNED_OUT        (gt0_rxbyteisaligned_i),
        .GT0_RXBYTEREALIGN_OUT          (gt0_rxbyterealign_i),
        .GT0_RXCOMMADET_OUT             (gt0_rxcommadet_i),
        .GT0_RXSLIDE_IN                 (gt0_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT0_GTRXRESET_IN               (gt0_gtrxreset_i),
        .GT0_RXDATA_OUT                 (gt0_rxdata_i),
        .GT0_RXOUTCLK_OUT               (gt0_rxoutclk_i),
        .GT0_RXPCSRESET_IN              (gt0_rxpcsreset_i),
        .GT0_RXUSRCLK_IN                (gt0_txusrclk_i),
        .GT0_RXUSRCLK2_IN               (gt0_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT0_GTXRXN_IN                  (RXN_IN[0]),
        .GT0_GTXRXP_IN                  (RXP_IN[0]),
        .GT0_RXCDRLOCK_OUT              (gt0_rxcdrlock_i),
        .GT0_RXELECIDLE_OUT             (gt0_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT0_RXBUFRESET_IN              (gt0_rxbufreset_i),
        .GT0_RXBUFSTATUS_OUT            (gt0_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT0_RXRESETDONE_OUT            (gt0_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT0_RXVALID_OUT                (gt0_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT0_TXPRECURSORINV_IN          (gt0_txprecursorinv_i),
        .GT0_TXUSERRDY_IN               (gt0_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT0_GTTXRESET_IN               (gt0_gttxreset_i),
        .GT0_TXDATA_IN                  (gt0_txdata_i),
        .GT0_TXOUTCLK_OUT               (gt0_txoutclk_i),
        .GT0_TXOUTCLKFABRIC_OUT         (gt0_txoutclkfabric_i),
        .GT0_TXOUTCLKPCS_OUT            (gt0_txoutclkpcs_i),
        .GT0_TXPCSRESET_IN              (gt0_txpcsreset_i),
        .GT0_TXUSRCLK_IN                (gt0_txusrclk_i),
        .GT0_TXUSRCLK2_IN               (gt0_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT0_GTXTXN_OUT                 (TXN_OUT[0]),
        .GT0_GTXTXP_OUT                 (TXP_OUT[0]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT0_TXBUFSTATUS_OUT            (gt0_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT0_TXRESETDONE_OUT            (gt0_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT1  (X0Y1)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT1_GTREFCLK0_IN               (q0_clk0_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT1_CPLLFBCLKLOST_OUT          (gt1_cpllfbclklost_i),
        .GT1_CPLLLOCK_OUT               (gt1_cplllock_i),
        .GT1_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT1_CPLLREFCLKLOST_OUT         (gt1_cpllrefclklost_i),
        .GT1_CPLLRESET_IN               (gt1_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT1_EYESCANDATAERROR_OUT       (gt1_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT1_LOOPBACK_IN                (gt1_loopback_i),
        .GT1_RXPD_IN                    (gt1_rxpd_i),
        .GT1_TXPD_IN                    (gt1_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT1_RXUSERRDY_IN               (gt1_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT1_RXCLKCORCNT_OUT            (gt1_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT1_RXBYTEISALIGNED_OUT        (gt1_rxbyteisaligned_i),
        .GT1_RXBYTEREALIGN_OUT          (gt1_rxbyterealign_i),
        .GT1_RXCOMMADET_OUT             (gt1_rxcommadet_i),
        .GT1_RXSLIDE_IN                 (gt1_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT1_GTRXRESET_IN               (gt1_gtrxreset_i),
        .GT1_RXDATA_OUT                 (gt1_rxdata_i),
        .GT1_RXOUTCLK_OUT               (gt1_rxoutclk_i),
        .GT1_RXPCSRESET_IN              (gt1_rxpcsreset_i),
        .GT1_RXUSRCLK_IN                (gt0_txusrclk_i),
        .GT1_RXUSRCLK2_IN               (gt0_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT1_GTXRXN_IN                  (RXN_IN[1]),
        .GT1_GTXRXP_IN                  (RXP_IN[1]),
        .GT1_RXCDRLOCK_OUT              (gt1_rxcdrlock_i),
        .GT1_RXELECIDLE_OUT             (gt1_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT1_RXBUFRESET_IN              (gt1_rxbufreset_i),
        .GT1_RXBUFSTATUS_OUT            (gt1_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT1_RXRESETDONE_OUT            (gt1_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT1_RXVALID_OUT                (gt1_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT1_TXPRECURSORINV_IN          (gt1_txprecursorinv_i),
        .GT1_TXUSERRDY_IN               (gt1_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT1_GTTXRESET_IN               (gt1_gttxreset_i),
        .GT1_TXDATA_IN                  (gt1_txdata_i),
        .GT1_TXOUTCLK_OUT               (gt1_txoutclk_i),
        .GT1_TXOUTCLKFABRIC_OUT         (gt1_txoutclkfabric_i),
        .GT1_TXOUTCLKPCS_OUT            (gt1_txoutclkpcs_i),
        .GT1_TXPCSRESET_IN              (gt1_txpcsreset_i),
        .GT1_TXUSRCLK_IN                (gt0_txusrclk_i),
        .GT1_TXUSRCLK2_IN               (gt0_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT1_GTXTXN_OUT                 (TXN_OUT[1]),
        .GT1_GTXTXP_OUT                 (TXP_OUT[1]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT1_TXBUFSTATUS_OUT            (gt1_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT1_TXRESETDONE_OUT            (gt1_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT2  (X0Y2)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT2_GTREFCLK0_IN               (q0_clk1_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT2_CPLLFBCLKLOST_OUT          (gt2_cpllfbclklost_i),
        .GT2_CPLLLOCK_OUT               (gt2_cplllock_i),
        .GT2_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT2_CPLLREFCLKLOST_OUT         (gt2_cpllrefclklost_i),
        .GT2_CPLLRESET_IN               (gt2_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT2_EYESCANDATAERROR_OUT       (gt2_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT2_LOOPBACK_IN                (gt2_loopback_i),
        .GT2_RXPD_IN                    (gt2_rxpd_i),
        .GT2_TXPD_IN                    (gt2_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT2_RXUSERRDY_IN               (gt2_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT2_RXCLKCORCNT_OUT            (gt2_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT2_RXBYTEISALIGNED_OUT        (gt2_rxbyteisaligned_i),
        .GT2_RXBYTEREALIGN_OUT          (gt2_rxbyterealign_i),
        .GT2_RXCOMMADET_OUT             (gt2_rxcommadet_i),
        .GT2_RXSLIDE_IN                 (gt2_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT2_GTRXRESET_IN               (gt2_gtrxreset_i),
        .GT2_RXDATA_OUT                 (gt2_rxdata_i),
        .GT2_RXOUTCLK_OUT               (gt2_rxoutclk_i),
        .GT2_RXPCSRESET_IN              (gt2_rxpcsreset_i),
        .GT2_RXUSRCLK_IN                (gt2_txusrclk_i),
        .GT2_RXUSRCLK2_IN               (gt2_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT2_GTXRXN_IN                  (RXN_IN[2]),
        .GT2_GTXRXP_IN                  (RXP_IN[2]),
        .GT2_RXCDRLOCK_OUT              (gt2_rxcdrlock_i),
        .GT2_RXELECIDLE_OUT             (gt2_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT2_RXBUFRESET_IN              (gt2_rxbufreset_i),
        .GT2_RXBUFSTATUS_OUT            (gt2_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT2_RXRESETDONE_OUT            (gt2_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT2_RXVALID_OUT                (gt2_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT2_TXPRECURSORINV_IN          (gt2_txprecursorinv_i),
        .GT2_TXUSERRDY_IN               (gt2_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT2_GTTXRESET_IN               (gt2_gttxreset_i),
        .GT2_TXDATA_IN                  (gt2_txdata_i),
        .GT2_TXOUTCLK_OUT               (gt2_txoutclk_i),
        .GT2_TXOUTCLKFABRIC_OUT         (gt2_txoutclkfabric_i),
        .GT2_TXOUTCLKPCS_OUT            (gt2_txoutclkpcs_i),
        .GT2_TXPCSRESET_IN              (gt2_txpcsreset_i),
        .GT2_TXUSRCLK_IN                (gt2_txusrclk_i),
        .GT2_TXUSRCLK2_IN               (gt2_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT2_GTXTXN_OUT                 (TXN_OUT[2]),
        .GT2_GTXTXP_OUT                 (TXP_OUT[2]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT2_TXBUFSTATUS_OUT            (gt2_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT2_TXRESETDONE_OUT            (gt2_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT3  (X0Y3)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT3_GTREFCLK0_IN               (q0_clk1_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT3_CPLLFBCLKLOST_OUT          (gt3_cpllfbclklost_i),
        .GT3_CPLLLOCK_OUT               (gt3_cplllock_i),
        .GT3_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT3_CPLLREFCLKLOST_OUT         (gt3_cpllrefclklost_i),
        .GT3_CPLLRESET_IN               (gt3_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT3_EYESCANDATAERROR_OUT       (gt3_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT3_LOOPBACK_IN                (gt3_loopback_i),
        .GT3_RXPD_IN                    (gt3_rxpd_i),
        .GT3_TXPD_IN                    (gt3_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT3_RXUSERRDY_IN               (gt3_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT3_RXCLKCORCNT_OUT            (gt3_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT3_RXBYTEISALIGNED_OUT        (gt3_rxbyteisaligned_i),
        .GT3_RXBYTEREALIGN_OUT          (gt3_rxbyterealign_i),
        .GT3_RXCOMMADET_OUT             (gt3_rxcommadet_i),
        .GT3_RXSLIDE_IN                 (gt3_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT3_GTRXRESET_IN               (gt3_gtrxreset_i),
        .GT3_RXDATA_OUT                 (gt3_rxdata_i),
        .GT3_RXOUTCLK_OUT               (gt3_rxoutclk_i),
        .GT3_RXPCSRESET_IN              (gt3_rxpcsreset_i),
        .GT3_RXUSRCLK_IN                (gt2_txusrclk_i),
        .GT3_RXUSRCLK2_IN               (gt2_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT3_GTXRXN_IN                  (RXN_IN[3]),
        .GT3_GTXRXP_IN                  (RXP_IN[3]),
        .GT3_RXCDRLOCK_OUT              (gt3_rxcdrlock_i),
        .GT3_RXELECIDLE_OUT             (gt3_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT3_RXBUFRESET_IN              (gt3_rxbufreset_i),
        .GT3_RXBUFSTATUS_OUT            (gt3_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT3_RXRESETDONE_OUT            (gt3_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT3_RXVALID_OUT                (gt3_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT3_TXPRECURSORINV_IN          (gt3_txprecursorinv_i),
        .GT3_TXUSERRDY_IN               (gt3_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT3_GTTXRESET_IN               (gt3_gttxreset_i),
        .GT3_TXDATA_IN                  (gt3_txdata_i),
        .GT3_TXOUTCLK_OUT               (gt3_txoutclk_i),
        .GT3_TXOUTCLKFABRIC_OUT         (gt3_txoutclkfabric_i),
        .GT3_TXOUTCLKPCS_OUT            (gt3_txoutclkpcs_i),
        .GT3_TXPCSRESET_IN              (gt3_txpcsreset_i),
        .GT3_TXUSRCLK_IN                (gt2_txusrclk_i),
        .GT3_TXUSRCLK2_IN               (gt2_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT3_GTXTXN_OUT                 (TXN_OUT[3]),
        .GT3_GTXTXP_OUT                 (TXP_OUT[3]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT3_TXBUFSTATUS_OUT            (gt3_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT3_TXRESETDONE_OUT            (gt3_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT4  (X0Y4)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT4_GTREFCLK0_IN               (q1_clk0_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT4_CPLLFBCLKLOST_OUT          (gt4_cpllfbclklost_i),
        .GT4_CPLLLOCK_OUT               (gt4_cplllock_i),
        .GT4_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT4_CPLLREFCLKLOST_OUT         (gt4_cpllrefclklost_i),
        .GT4_CPLLRESET_IN               (gt4_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT4_EYESCANDATAERROR_OUT       (gt4_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT4_LOOPBACK_IN                (gt4_loopback_i),
        .GT4_RXPD_IN                    (gt4_rxpd_i),
        .GT4_TXPD_IN                    (gt4_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT4_RXUSERRDY_IN               (gt4_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT4_RXCLKCORCNT_OUT            (gt4_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT4_RXBYTEISALIGNED_OUT        (gt4_rxbyteisaligned_i),
        .GT4_RXBYTEREALIGN_OUT          (gt4_rxbyterealign_i),
        .GT4_RXCOMMADET_OUT             (gt4_rxcommadet_i),
        .GT4_RXSLIDE_IN                 (gt4_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT4_GTRXRESET_IN               (gt4_gtrxreset_i),
        .GT4_RXDATA_OUT                 (gt4_rxdata_i),
        .GT4_RXOUTCLK_OUT               (gt4_rxoutclk_i),
        .GT4_RXPCSRESET_IN              (gt4_rxpcsreset_i),
        .GT4_RXUSRCLK_IN                (gt4_txusrclk_i),
        .GT4_RXUSRCLK2_IN               (gt4_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT4_GTXRXN_IN                  (RXN_IN[4]),
        .GT4_GTXRXP_IN                  (RXP_IN[4]),
        .GT4_RXCDRLOCK_OUT              (gt4_rxcdrlock_i),
        .GT4_RXELECIDLE_OUT             (gt4_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT4_RXBUFRESET_IN              (gt4_rxbufreset_i),
        .GT4_RXBUFSTATUS_OUT            (gt4_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT4_RXRESETDONE_OUT            (gt4_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT4_RXVALID_OUT                (gt4_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT4_TXPRECURSORINV_IN          (gt4_txprecursorinv_i),
        .GT4_TXUSERRDY_IN               (gt4_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT4_GTTXRESET_IN               (gt4_gttxreset_i),
        .GT4_TXDATA_IN                  (gt4_txdata_i),
        .GT4_TXOUTCLK_OUT               (gt4_txoutclk_i),
        .GT4_TXOUTCLKFABRIC_OUT         (gt4_txoutclkfabric_i),
        .GT4_TXOUTCLKPCS_OUT            (gt4_txoutclkpcs_i),
        .GT4_TXPCSRESET_IN              (gt4_txpcsreset_i),
        .GT4_TXUSRCLK_IN                (gt4_txusrclk_i),
        .GT4_TXUSRCLK2_IN               (gt4_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT4_GTXTXN_OUT                 (TXN_OUT[4]),
        .GT4_GTXTXP_OUT                 (TXP_OUT[4]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT4_TXBUFSTATUS_OUT            (gt4_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT4_TXRESETDONE_OUT            (gt4_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT5  (X0Y5)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT5_GTREFCLK0_IN               (q1_clk0_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT5_CPLLFBCLKLOST_OUT          (gt5_cpllfbclklost_i),
        .GT5_CPLLLOCK_OUT               (gt5_cplllock_i),
        .GT5_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT5_CPLLREFCLKLOST_OUT         (gt5_cpllrefclklost_i),
        .GT5_CPLLRESET_IN               (gt5_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT5_EYESCANDATAERROR_OUT       (gt5_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT5_LOOPBACK_IN                (gt5_loopback_i),
        .GT5_RXPD_IN                    (gt5_rxpd_i),
        .GT5_TXPD_IN                    (gt5_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT5_RXUSERRDY_IN               (gt5_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT5_RXCLKCORCNT_OUT            (gt5_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT5_RXBYTEISALIGNED_OUT        (gt5_rxbyteisaligned_i),
        .GT5_RXBYTEREALIGN_OUT          (gt5_rxbyterealign_i),
        .GT5_RXCOMMADET_OUT             (gt5_rxcommadet_i),
        .GT5_RXSLIDE_IN                 (gt5_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT5_GTRXRESET_IN               (gt5_gtrxreset_i),
        .GT5_RXDATA_OUT                 (gt5_rxdata_i),
        .GT5_RXOUTCLK_OUT               (gt5_rxoutclk_i),
        .GT5_RXPCSRESET_IN              (gt5_rxpcsreset_i),
        .GT5_RXUSRCLK_IN                (gt4_txusrclk_i),
        .GT5_RXUSRCLK2_IN               (gt4_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT5_GTXRXN_IN                  (RXN_IN[5]),
        .GT5_GTXRXP_IN                  (RXP_IN[5]),
        .GT5_RXCDRLOCK_OUT              (gt5_rxcdrlock_i),
        .GT5_RXELECIDLE_OUT             (gt5_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT5_RXBUFRESET_IN              (gt5_rxbufreset_i),
        .GT5_RXBUFSTATUS_OUT            (gt5_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT5_RXRESETDONE_OUT            (gt5_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT5_RXVALID_OUT                (gt5_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT5_TXPRECURSORINV_IN          (gt5_txprecursorinv_i),
        .GT5_TXUSERRDY_IN               (gt5_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT5_GTTXRESET_IN               (gt5_gttxreset_i),
        .GT5_TXDATA_IN                  (gt5_txdata_i),
        .GT5_TXOUTCLK_OUT               (gt5_txoutclk_i),
        .GT5_TXOUTCLKFABRIC_OUT         (gt5_txoutclkfabric_i),
        .GT5_TXOUTCLKPCS_OUT            (gt5_txoutclkpcs_i),
        .GT5_TXPCSRESET_IN              (gt5_txpcsreset_i),
        .GT5_TXUSRCLK_IN                (gt4_txusrclk_i),
        .GT5_TXUSRCLK2_IN               (gt4_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT5_GTXTXN_OUT                 (TXN_OUT[5]),
        .GT5_GTXTXP_OUT                 (TXP_OUT[5]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT5_TXBUFSTATUS_OUT            (gt5_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT5_TXRESETDONE_OUT            (gt5_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT6  (X0Y6)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT6_GTREFCLK0_IN               (q1_clk1_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT6_CPLLFBCLKLOST_OUT          (gt6_cpllfbclklost_i),
        .GT6_CPLLLOCK_OUT               (gt6_cplllock_i),
        .GT6_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT6_CPLLREFCLKLOST_OUT         (gt6_cpllrefclklost_i),
        .GT6_CPLLRESET_IN               (gt6_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT6_EYESCANDATAERROR_OUT       (gt6_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT6_LOOPBACK_IN                (gt6_loopback_i),
        .GT6_RXPD_IN                    (gt6_rxpd_i),
        .GT6_TXPD_IN                    (gt6_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT6_RXUSERRDY_IN               (gt6_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT6_RXCLKCORCNT_OUT            (gt6_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT6_RXBYTEISALIGNED_OUT        (gt6_rxbyteisaligned_i),
        .GT6_RXBYTEREALIGN_OUT          (gt6_rxbyterealign_i),
        .GT6_RXCOMMADET_OUT             (gt6_rxcommadet_i),
        .GT6_RXSLIDE_IN                 (gt6_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT6_GTRXRESET_IN               (gt6_gtrxreset_i),
        .GT6_RXDATA_OUT                 (gt6_rxdata_i),
        .GT6_RXOUTCLK_OUT               (gt6_rxoutclk_i),
        .GT6_RXPCSRESET_IN              (gt6_rxpcsreset_i),
        .GT6_RXUSRCLK_IN                (gt6_txusrclk_i),
        .GT6_RXUSRCLK2_IN               (gt6_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT6_GTXRXN_IN                  (RXN_IN[6]),
        .GT6_GTXRXP_IN                  (RXP_IN[6]),
        .GT6_RXCDRLOCK_OUT              (gt6_rxcdrlock_i),
        .GT6_RXELECIDLE_OUT             (gt6_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT6_RXBUFRESET_IN              (gt6_rxbufreset_i),
        .GT6_RXBUFSTATUS_OUT            (gt6_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT6_RXRESETDONE_OUT            (gt6_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT6_RXVALID_OUT                (gt6_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT6_TXPRECURSORINV_IN          (gt6_txprecursorinv_i),
        .GT6_TXUSERRDY_IN               (gt6_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT6_GTTXRESET_IN               (gt6_gttxreset_i),
        .GT6_TXDATA_IN                  (gt6_txdata_i),
        .GT6_TXOUTCLK_OUT               (gt6_txoutclk_i),
        .GT6_TXOUTCLKFABRIC_OUT         (gt6_txoutclkfabric_i),
        .GT6_TXOUTCLKPCS_OUT            (gt6_txoutclkpcs_i),
        .GT6_TXPCSRESET_IN              (gt6_txpcsreset_i),
        .GT6_TXUSRCLK_IN                (gt6_txusrclk_i),
        .GT6_TXUSRCLK2_IN               (gt6_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT6_GTXTXN_OUT                 (TXN_OUT[6]),
        .GT6_GTXTXP_OUT                 (TXP_OUT[6]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT6_TXBUFSTATUS_OUT            (gt6_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT6_TXRESETDONE_OUT            (gt6_txresetdone_i),


 
 

        //_____________________________________________________________________
        //_____________________________________________________________________
        //GT7  (X0Y7)

        //----------------------- Channel - Ref Clock Ports ------------------------
        .GT7_GTREFCLK0_IN               (q1_clk1_refclk_i),
        //------------------------------ Channel PLL -------------------------------
        .GT7_CPLLFBCLKLOST_OUT          (gt7_cpllfbclklost_i),
        .GT7_CPLLLOCK_OUT               (gt7_cplllock_i),
        .GT7_CPLLLOCKDETCLK_IN          (drpclk_in_i),
        .GT7_CPLLREFCLKLOST_OUT         (gt7_cpllrefclklost_i),
        .GT7_CPLLRESET_IN               (gt7_cpllreset_i),
        //----------------------------- Eye Scan Ports -----------------------------
        .GT7_EYESCANDATAERROR_OUT       (gt7_eyescandataerror_i),
        //---------------------- Loopback and Powerdown Ports ----------------------
        .GT7_LOOPBACK_IN                (gt7_loopback_i),
        .GT7_RXPD_IN                    (gt7_rxpd_i),
        .GT7_TXPD_IN                    (gt7_txpd_i),
        //----------------------------- Receive Ports ------------------------------
        .GT7_RXUSERRDY_IN               (gt7_rxuserrdy_i),
        //----------------- Receive Ports - Clock Correction Ports -----------------
        .GT7_RXCLKCORCNT_OUT            (gt7_rxclkcorcnt_i),
        //------------- Receive Ports - Comma Detection and Alignment --------------
        .GT7_RXBYTEISALIGNED_OUT        (gt7_rxbyteisaligned_i),
        .GT7_RXBYTEREALIGN_OUT          (gt7_rxbyterealign_i),
        .GT7_RXCOMMADET_OUT             (gt7_rxcommadet_i),
        .GT7_RXSLIDE_IN                 (gt7_rxslide_i),
        //----------------- Receive Ports - RX Data Path interface -----------------
        .GT7_GTRXRESET_IN               (gt7_gtrxreset_i),
        .GT7_RXDATA_OUT                 (gt7_rxdata_i),
        .GT7_RXOUTCLK_OUT               (gt7_rxoutclk_i),
        .GT7_RXPCSRESET_IN              (gt7_rxpcsreset_i),
        .GT7_RXUSRCLK_IN                (gt6_txusrclk_i),
        .GT7_RXUSRCLK2_IN               (gt6_txusrclk_i),
        //----- Receive Ports - RX Driver,OOB signalling,Coupling and Eq.,CDR ------
        .GT7_GTXRXN_IN                  (RXN_IN[7]),
        .GT7_GTXRXP_IN                  (RXP_IN[7]),
        .GT7_RXCDRLOCK_OUT              (gt7_rxcdrlock_i),
        .GT7_RXELECIDLE_OUT             (gt7_rxelecidle_i),
        //------ Receive Ports - RX Elastic Buffer and Phase Alignment Ports -------
        .GT7_RXBUFRESET_IN              (gt7_rxbufreset_i),
        .GT7_RXBUFSTATUS_OUT            (gt7_rxbufstatus_i),
        //---------------------- Receive Ports - RX PLL Ports ----------------------
        .GT7_RXRESETDONE_OUT            (gt7_rxresetdone_i),
        //------------ Receive Ports - RX Pipe Control for PCI Express -------------
        .GT7_RXVALID_OUT                (gt7_rxvalid_i),
        //----------------------------- Transmit Ports -----------------------------
        .GT7_TXPRECURSORINV_IN          (gt7_txprecursorinv_i),
        .GT7_TXUSERRDY_IN               (gt7_txuserrdy_i),
        //---------------- Transmit Ports - TX Data Path interface -----------------
        .GT7_GTTXRESET_IN               (gt7_gttxreset_i),
        .GT7_TXDATA_IN                  (gt7_txdata_i),
        .GT7_TXOUTCLK_OUT               (gt7_txoutclk_i),
        .GT7_TXOUTCLKFABRIC_OUT         (gt7_txoutclkfabric_i),
        .GT7_TXOUTCLKPCS_OUT            (gt7_txoutclkpcs_i),
        .GT7_TXPCSRESET_IN              (gt7_txpcsreset_i),
        .GT7_TXUSRCLK_IN                (gt6_txusrclk_i),
        .GT7_TXUSRCLK2_IN               (gt6_txusrclk_i),
        //-------------- Transmit Ports - TX Driver and OOB signaling --------------
        .GT7_GTXTXN_OUT                 (TXN_OUT[7]),
        .GT7_GTXTXP_OUT                 (TXP_OUT[7]),
        //--------- Transmit Ports - TX Elastic Buffer and Phase Alignment ---------
        .GT7_TXBUFSTATUS_OUT            (gt7_txbufstatus_i),
        //--------------------- Transmit Ports - TX PLL Ports ----------------------
        .GT7_TXRESETDONE_OUT            (gt7_txresetdone_i)



    );



    //***********************************************************************//
    //                                                                       //
    //--------------------------- User Module Resets-------------------------//
    //                                                                       //
    //***********************************************************************//
    // All the User Modules i.e. FRAME_GEN, FRAME_CHECK and the sync modules
    // are held in reset till the RESETDONE goes high. 
    // The RESETDONE is registered a couple of times on *USRCLK2 and connected 
    // to the reset of the modules
    
    always @(posedge gt0_txusrclk_i or negedge gt0_rxresetdone_i)

    begin
        if (!gt0_rxresetdone_i)
        begin
            gt0_rxresetdone_r    <=   `DLY 1'b0;
            gt0_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt0_rxresetdone_r    <=   `DLY gt0_rxresetdone_i;
            gt0_rxresetdone_r2   <=   `DLY gt0_rxresetdone_r;
        end
    end

    always @(posedge gt0_txusrclk_i)
            gt0_rxresetdone_r3   <=   `DLY gt0_rxresetdone_r2;

    
    
    always @(posedge gt0_txusrclk_i or negedge gt0_txresetdone_i)

    begin
        if (!gt0_txresetdone_i)
        begin
            gt0_txresetdone_r    <=   `DLY 1'b0;
            gt0_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt0_txresetdone_r    <=   `DLY gt0_txresetdone_i;
            gt0_txresetdone_r2   <=   `DLY gt0_txresetdone_r;
        end
    end

    always @(posedge gt0_txusrclk_i or negedge gt1_rxresetdone_i)

    begin
        if (!gt1_rxresetdone_i)
        begin
            gt1_rxresetdone_r    <=   `DLY 1'b0;
            gt1_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt1_rxresetdone_r    <=   `DLY gt1_rxresetdone_i;
            gt1_rxresetdone_r2   <=   `DLY gt1_rxresetdone_r;
        end
    end

    always @(posedge gt0_txusrclk_i)
            gt1_rxresetdone_r3   <=   `DLY gt1_rxresetdone_r2;

    
    
    always @(posedge gt0_txusrclk_i or negedge gt1_txresetdone_i)

    begin
        if (!gt1_txresetdone_i)
        begin
            gt1_txresetdone_r    <=   `DLY 1'b0;
            gt1_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt1_txresetdone_r    <=   `DLY gt1_txresetdone_i;
            gt1_txresetdone_r2   <=   `DLY gt1_txresetdone_r;
        end
    end

    always @(posedge gt2_txusrclk_i or negedge gt2_rxresetdone_i)

    begin
        if (!gt2_rxresetdone_i)
        begin
            gt2_rxresetdone_r    <=   `DLY 1'b0;
            gt2_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt2_rxresetdone_r    <=   `DLY gt2_rxresetdone_i;
            gt2_rxresetdone_r2   <=   `DLY gt2_rxresetdone_r;
        end
    end

    always @(posedge gt2_txusrclk_i)
            gt2_rxresetdone_r3   <=   `DLY gt2_rxresetdone_r2;

    
    
    always @(posedge gt2_txusrclk_i or negedge gt2_txresetdone_i)

    begin
        if (!gt2_txresetdone_i)
        begin
            gt2_txresetdone_r    <=   `DLY 1'b0;
            gt2_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt2_txresetdone_r    <=   `DLY gt2_txresetdone_i;
            gt2_txresetdone_r2   <=   `DLY gt2_txresetdone_r;
        end
    end

    always @(posedge gt2_txusrclk_i or negedge gt3_rxresetdone_i)

    begin
        if (!gt3_rxresetdone_i)
        begin
            gt3_rxresetdone_r    <=   `DLY 1'b0;
            gt3_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt3_rxresetdone_r    <=   `DLY gt3_rxresetdone_i;
            gt3_rxresetdone_r2   <=   `DLY gt3_rxresetdone_r;
        end
    end

    always @(posedge gt2_txusrclk_i)
            gt3_rxresetdone_r3   <=   `DLY gt3_rxresetdone_r2;

    
    
    always @(posedge gt2_txusrclk_i or negedge gt3_txresetdone_i)

    begin
        if (!gt3_txresetdone_i)
        begin
            gt3_txresetdone_r    <=   `DLY 1'b0;
            gt3_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt3_txresetdone_r    <=   `DLY gt3_txresetdone_i;
            gt3_txresetdone_r2   <=   `DLY gt3_txresetdone_r;
        end
    end

    always @(posedge gt4_txusrclk_i or negedge gt4_rxresetdone_i)

    begin
        if (!gt4_rxresetdone_i)
        begin
            gt4_rxresetdone_r    <=   `DLY 1'b0;
            gt4_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt4_rxresetdone_r    <=   `DLY gt4_rxresetdone_i;
            gt4_rxresetdone_r2   <=   `DLY gt4_rxresetdone_r;
        end
    end

    always @(posedge gt4_txusrclk_i)
            gt4_rxresetdone_r3   <=   `DLY gt4_rxresetdone_r2;

    
    
    always @(posedge gt4_txusrclk_i or negedge gt4_txresetdone_i)

    begin
        if (!gt4_txresetdone_i)
        begin
            gt4_txresetdone_r    <=   `DLY 1'b0;
            gt4_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt4_txresetdone_r    <=   `DLY gt4_txresetdone_i;
            gt4_txresetdone_r2   <=   `DLY gt4_txresetdone_r;
        end
    end

    always @(posedge gt4_txusrclk_i or negedge gt5_rxresetdone_i)

    begin
        if (!gt5_rxresetdone_i)
        begin
            gt5_rxresetdone_r    <=   `DLY 1'b0;
            gt5_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt5_rxresetdone_r    <=   `DLY gt5_rxresetdone_i;
            gt5_rxresetdone_r2   <=   `DLY gt5_rxresetdone_r;
        end
    end

    always @(posedge gt4_txusrclk_i)
            gt5_rxresetdone_r3   <=   `DLY gt5_rxresetdone_r2;

    
    
    always @(posedge gt4_txusrclk_i or negedge gt5_txresetdone_i)

    begin
        if (!gt5_txresetdone_i)
        begin
            gt5_txresetdone_r    <=   `DLY 1'b0;
            gt5_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt5_txresetdone_r    <=   `DLY gt5_txresetdone_i;
            gt5_txresetdone_r2   <=   `DLY gt5_txresetdone_r;
        end
    end

    always @(posedge gt6_txusrclk_i or negedge gt6_rxresetdone_i)

    begin
        if (!gt6_rxresetdone_i)
        begin
            gt6_rxresetdone_r    <=   `DLY 1'b0;
            gt6_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt6_rxresetdone_r    <=   `DLY gt6_rxresetdone_i;
            gt6_rxresetdone_r2   <=   `DLY gt6_rxresetdone_r;
        end
    end

    always @(posedge gt6_txusrclk_i)
            gt6_rxresetdone_r3   <=   `DLY gt6_rxresetdone_r2;

    
    
    always @(posedge gt6_txusrclk_i or negedge gt6_txresetdone_i)

    begin
        if (!gt6_txresetdone_i)
        begin
            gt6_txresetdone_r    <=   `DLY 1'b0;
            gt6_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt6_txresetdone_r    <=   `DLY gt6_txresetdone_i;
            gt6_txresetdone_r2   <=   `DLY gt6_txresetdone_r;
        end
    end

    always @(posedge gt6_txusrclk_i or negedge gt7_rxresetdone_i)

    begin
        if (!gt7_rxresetdone_i)
        begin
            gt7_rxresetdone_r    <=   `DLY 1'b0;
            gt7_rxresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt7_rxresetdone_r    <=   `DLY gt7_rxresetdone_i;
            gt7_rxresetdone_r2   <=   `DLY gt7_rxresetdone_r;
        end
    end

    always @(posedge gt6_txusrclk_i)
            gt7_rxresetdone_r3   <=   `DLY gt7_rxresetdone_r2;

    
    
    always @(posedge gt6_txusrclk_i or negedge gt7_txresetdone_i)

    begin
        if (!gt7_txresetdone_i)
        begin
            gt7_txresetdone_r    <=   `DLY 1'b0;
            gt7_txresetdone_r2   <=   `DLY 1'b0;
        end
        else
        begin
            gt7_txresetdone_r    <=   `DLY gt7_txresetdone_i;
            gt7_txresetdone_r2   <=   `DLY gt7_txresetdone_r;
        end
    end



    //***********************************************************************//
    //                                                                       //
    //------------------------  Frame Generators  ---------------------------//
    //                                                                       //
    //***********************************************************************//
    // The example design uses Block RAM based frame generators to provide test
    // data to the GTs for transmission. By default the frame generators are 
    // loaded with an incrementing data sequence that includes commas/alignment
    // characters for alignment. If your protocol uses channel bonding, the 
    // frame generator will also be preloaded with a channel bonding sequence.
    
    // You can modify the data transmitted by changing the INIT values of the frame
    // generator in this file. Pay careful attention to bit order and the spacing
    // of your control and alignment characters.


    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt0_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt0_txdata_float_i,gt0_txdata_i,gt0_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt0_txusrclk_i),
        .SYSTEM_RESET                   (gt0_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt1_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt1_txdata_float_i,gt1_txdata_i,gt1_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt0_txusrclk_i),
        .SYSTEM_RESET                   (gt1_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt2_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt2_txdata_float_i,gt2_txdata_i,gt2_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt2_txusrclk_i),
        .SYSTEM_RESET                   (gt2_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt3_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt3_txdata_float_i,gt3_txdata_i,gt3_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt2_txusrclk_i),
        .SYSTEM_RESET                   (gt3_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt4_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt4_txdata_float_i,gt4_txdata_i,gt4_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt4_txusrclk_i),
        .SYSTEM_RESET                   (gt4_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt5_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt5_txdata_float_i,gt5_txdata_i,gt5_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt4_txusrclk_i),
        .SYSTEM_RESET                   (gt5_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt6_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt6_txdata_float_i,gt6_txdata_i,gt6_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt6_txusrclk_i),
        .SYSTEM_RESET                   (gt6_tx_system_reset_c)
    );

    ROCKETIO_WRAPPER_TILE_GT_FRAME_GEN #
    (
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM)
    )
    gt7_frame_gen
    (
        // User Interface
        .TX_DATA_OUT                    ({gt7_txdata_float_i,gt7_txdata_i,gt7_txdata_float16_i}),
        .TXCTRL_OUT                     (),

        // System Interface
        .USER_CLK                       (gt6_txusrclk_i),
        .SYSTEM_RESET                   (gt7_tx_system_reset_c)
    );

    //***********************************************************************//
    //                                                                       //
    //------------------------  Frame Checkers  -----------------------------//
    //                                                                       //
    //***********************************************************************//
    // The example design uses Block RAM based frame checkers to verify incoming  
    // data. By default the frame generators are loaded with a data sequence that 
    // matches the outgoing sequence of the frame generators for the TX ports.
    
    // You can modify the expected data sequence by changing the INIT values of the frame
    // checkers in this file. Pay careful attention to bit order and the spacing
    // of your control and alignment characters.
    
    // When the frame checker receives data, it attempts to synchronise to the 
    // incoming pattern by looking for the first sequence in the pattern. Once it 
    // finds the first sequence, it increments through the sequence, and indicates an 
    // error whenever the next value received does not match the expected value.


    assign gt0_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt0_matchn_i;

    // gt0_frame_check0 is always connected to the lane with the start of char
    // and this lane starts off the data checking on all the other lanes. The INC_IN port is tied off
    assign gt0_inc_in_i = 1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt0_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt0_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt0_txusrclk_i),
        .SYSTEM_RESET                   (gt0_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt0_error_count_i),
        .RX_SLIDE                       (gt0_rxslide_i),
        .TRACK_DATA_OUT                 (gt0_track_data_i)
    );


    assign gt1_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt1_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt1_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt1_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt1_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt0_txusrclk_i),
        .SYSTEM_RESET                   (gt1_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt1_error_count_i),
        .RX_SLIDE                       (gt1_rxslide_i),
        .TRACK_DATA_OUT                 (gt1_track_data_i)
    );


    assign gt2_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt2_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt2_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt2_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt2_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt2_txusrclk_i),
        .SYSTEM_RESET                   (gt2_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt2_error_count_i),
        .RX_SLIDE                       (gt2_rxslide_i),
        .TRACK_DATA_OUT                 (gt2_track_data_i)
    );


    assign gt3_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt3_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt3_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt3_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt3_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt2_txusrclk_i),
        .SYSTEM_RESET                   (gt3_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt3_error_count_i),
        .RX_SLIDE                       (gt3_rxslide_i),
        .TRACK_DATA_OUT                 (gt3_track_data_i)
    );


    assign gt4_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt4_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt4_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt4_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt4_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt4_txusrclk_i),
        .SYSTEM_RESET                   (gt4_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt4_error_count_i),
        .RX_SLIDE                       (gt4_rxslide_i),
        .TRACK_DATA_OUT                 (gt4_track_data_i)
    );


    assign gt5_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt5_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt5_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt5_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt5_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt4_txusrclk_i),
        .SYSTEM_RESET                   (gt5_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt5_error_count_i),
        .RX_SLIDE                       (gt5_rxslide_i),
        .TRACK_DATA_OUT                 (gt5_track_data_i)
    );


    assign gt6_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt6_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt6_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt6_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt6_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt6_txusrclk_i),
        .SYSTEM_RESET                   (gt6_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt6_error_count_i),
        .RX_SLIDE                       (gt6_rxslide_i),
        .TRACK_DATA_OUT                 (gt6_track_data_i)
    );


    assign gt7_frame_check_reset_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?reset_on_data_error_i:gt7_matchn_i;

    // in the "independent lanes" configuration, each of the lanes looks for the unique start char and
    // in this case, the INC_IN port is tied off.
    // Else, the data checking is triggered by the "master" lane
    assign gt7_inc_in_i = (EXAMPLE_CONFIG_INDEPENDENT_LANES==0)?gt0_inc_out_i:1'b0;

    ROCKETIO_WRAPPER_TILE_GT_FRAME_CHECK #
    (
        .RX_DATA_WIDTH(16),
        .RXCTRL_WIDTH(2),
        .WORDS_IN_BRAM(EXAMPLE_WORDS_IN_BRAM),
        .START_OF_PACKET_CHAR(16'h027c)
    )
    gt7_frame_check
    (
        // GT Interface
        .RX_DATA_IN                     (gt7_rxdata_i),
        .RXENMCOMMADET_OUT              ( ),
        .RXENPCOMMADET_OUT              ( ),
        // System Interface
        .USER_CLK                       (gt6_txusrclk_i),
        .SYSTEM_RESET                   (gt7_rx_system_reset_c),
        .ERROR_COUNT_OUT                (gt7_error_count_i),
        .RX_SLIDE                       (gt7_rxslide_i),
        .TRACK_DATA_OUT                 (gt7_track_data_i)
    );



    assign TRACK_DATA_OUT = track_data_out_i;

    assign track_data_out_i = 
                                gt0_track_data_i &
                                gt1_track_data_i &
                                gt2_track_data_i &
                                gt3_track_data_i &
                                gt4_track_data_i &
                                gt5_track_data_i &
                                gt6_track_data_i &
                                gt7_track_data_i ;






















//-------------------------------------------------------------------------------------


    //***********************************************************************//
    //                                                                       //
    //--------------------- Chipscope Connections ---------------------------//
    //                                                                       //
    //***********************************************************************//
    // When the example design is run in hardware, it uses chipscope to allow the
    // example design and GT wrapper to be controlled and monitored. The 
    // EXAMPLE_USE_CHIPSCOPE parameter allows chipscope to be removed for simulation.
generate
if (EXAMPLE_USE_CHIPSCOPE==1) 
begin : chipscope

    // Shared VIO for all GTs
    data_vio shared_vio_i
    (
      .control                          (shared_vio_control_i),
      .async_in                         (shared_vio_in_i),
      .async_out                        (shared_vio_out_i),
      .sync_in                          (tied_to_ground_vec_i[31:0]),
      .sync_out                         (),
      .clk                              (tied_to_ground_i)
    );

    // ICON for all VIOs
    icon icon_i
    (
      .control0                         (shared_vio_control_i),
      .control1                         (tx_data_vio_control_i),
      .control2                         (rx_data_vio_control_i),
      .control3                         (ila_control_i)
    );


    // TX VIO
    data_vio tx_data_vio_i
    (
      .control                          (tx_data_vio_control_i),
      .async_in                         (tx_data_vio_async_in_i),
      .async_out                        (tx_data_vio_async_out_i),
      .sync_in                          (tx_data_vio_sync_in_i),
      .sync_out                         (tx_data_vio_sync_out_i),
      .clk                              (tx_vio_clk_i)
    );
    
    // RX VIO
    data_vio rx_data_vio_i
    (
      .control                          (rx_data_vio_control_i),
      .async_in                         (rx_data_vio_async_in_i),
      .async_out                        (rx_data_vio_async_out_i),
      .sync_in                          (rx_data_vio_sync_in_i),
      .sync_out                         (rx_data_vio_sync_out_i),
      .clk                              (rx_vio_ila_clk_i)
    );
    
    // RX ILA
    ila ila_i
    (
      .control                          (ila_control_i),
      .clk                              (rx_vio_ila_clk_i),
      .trig0                            (ila_in_i)
    );

    // The TX VIO uses GT0's TXUSRCLK2
    assign  tx_vio_clk_i = gt0_txusrclk_i;

    // The RX VIO and ILA uses GT0's RXUSRCLK2
    assign  rx_vio_ila_clk_i = gt0_txusrclk_i;

    // assign resets for frame_gen modules
    assign  gt0_tx_system_reset_c = !gt0_txresetdone_r2 || user_tx_reset_i;
    assign  gt1_tx_system_reset_c = !gt1_txresetdone_r2 || user_tx_reset_i;
    assign  gt2_tx_system_reset_c = !gt2_txresetdone_r2 || user_tx_reset_i;
    assign  gt3_tx_system_reset_c = !gt3_txresetdone_r2 || user_tx_reset_i;
    assign  gt4_tx_system_reset_c = !gt4_txresetdone_r2 || user_tx_reset_i;
    assign  gt5_tx_system_reset_c = !gt5_txresetdone_r2 || user_tx_reset_i;
    assign  gt6_tx_system_reset_c = !gt6_txresetdone_r2 || user_tx_reset_i;
    assign  gt7_tx_system_reset_c = !gt7_txresetdone_r2 || user_tx_reset_i;

    // assign resets for frame_check modules
    assign  gt0_rx_system_reset_c = !gt0_rxresetdone_r3 || user_rx_reset_i;
    assign  gt1_rx_system_reset_c = !gt1_rxresetdone_r3 || user_rx_reset_i;
    assign  gt2_rx_system_reset_c = !gt2_rxresetdone_r3 || user_rx_reset_i;
    assign  gt3_rx_system_reset_c = !gt3_rxresetdone_r3 || user_rx_reset_i;
    assign  gt4_rx_system_reset_c = !gt4_rxresetdone_r3 || user_rx_reset_i;
    assign  gt5_rx_system_reset_c = !gt5_rxresetdone_r3 || user_rx_reset_i;
    assign  gt6_rx_system_reset_c = !gt6_rxresetdone_r3 || user_rx_reset_i;
    assign  gt7_rx_system_reset_c = !gt7_rxresetdone_r3 || user_rx_reset_i;

    assign  gt0_gtrxreset_i = gtrxreset_i || !gt0_cplllock_i;
    assign  gt0_gttxreset_i = gttxreset_i || !gt0_cplllock_i;
    assign  gt1_gtrxreset_i = gtrxreset_i || !gt1_cplllock_i;
    assign  gt1_gttxreset_i = gttxreset_i || !gt1_cplllock_i;
    assign  gt2_gtrxreset_i = gtrxreset_i || !gt2_cplllock_i;
    assign  gt2_gttxreset_i = gttxreset_i || !gt2_cplllock_i;
    assign  gt3_gtrxreset_i = gtrxreset_i || !gt3_cplllock_i;
    assign  gt3_gttxreset_i = gttxreset_i || !gt3_cplllock_i;
    assign  gt4_gtrxreset_i = gtrxreset_i || !gt4_cplllock_i;
    assign  gt4_gttxreset_i = gttxreset_i || !gt4_cplllock_i;
    assign  gt5_gtrxreset_i = gtrxreset_i || !gt5_cplllock_i;
    assign  gt5_gttxreset_i = gttxreset_i || !gt5_cplllock_i;
    assign  gt6_gtrxreset_i = gtrxreset_i || !gt6_cplllock_i;
    assign  gt6_gttxreset_i = gttxreset_i || !gt6_cplllock_i;
    assign  gt7_gtrxreset_i = gtrxreset_i || !gt7_cplllock_i;
    assign  gt7_gttxreset_i = gttxreset_i || !gt7_cplllock_i;


    	assign  gt0_cpllreset_i = cpllreset_i;
    	assign  gt1_cpllreset_i = cpllreset_i;
    	assign  gt2_cpllreset_i = cpllreset_i;
    	assign  gt3_cpllreset_i = cpllreset_i;
    	assign  gt4_cpllreset_i = cpllreset_i;
    	assign  gt5_cpllreset_i = cpllreset_i;
    	assign  gt6_cpllreset_i = cpllreset_i;
    	assign  gt7_cpllreset_i = cpllreset_i;


    // Shared VIO Outputs
    assign  gttxreset_i                          =  shared_vio_out_i[31];
    assign  gtrxreset_i                          =  shared_vio_out_i[30];
    assign  user_tx_reset_i                      =  shared_vio_out_i[29];
    assign  user_rx_reset_i                      =  shared_vio_out_i[28];
    assign  mux_sel_i                            =  shared_vio_out_i[27:25];
    assign  cpllreset_i                          =  shared_vio_out_i[24];

    // Shared VIO Inputs
    assign  shared_vio_in_i[31:0]                =  32'b00000000000000000000000000000000;

    // Chipscope connections on GT 0
    assign  gt0_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt0_tx_data_vio_sync_in_i[31]        =  gt0_txresetdone_i;
    assign  gt0_tx_data_vio_sync_in_i[30:29]     =  gt0_txbufstatus_i;
    assign  gt0_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt0_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt0_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt0_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt0_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt0_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt0_rx_data_vio_sync_in_i[31]        =  gt0_rxresetdone_i;
    assign  gt0_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt0_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt0_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt0_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt0_ila_in_i[163:162]                =  gt0_rxclkcorcnt_i;
    assign  gt0_ila_in_i[161]                    =  gt0_rxbyteisaligned_i;
    assign  gt0_ila_in_i[160]                    =  gt0_rxbyterealign_i;
    assign  gt0_ila_in_i[159]                    =  gt0_rxcommadet_i;
    assign  gt0_ila_in_i[158:143]                =  gt0_rxdata_i;
    assign  gt0_ila_in_i[142:140]                =  gt0_rxbufstatus_i;
    assign  gt0_ila_in_i[139]                    =  gt0_rxvalid_i;
    assign  gt0_ila_in_i[138:131]                =  gt0_error_count_i;
    assign  gt0_ila_in_i[130]                    =  gt0_track_data_i;
    assign  gt0_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 1
    assign  gt1_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt1_tx_data_vio_sync_in_i[31]        =  gt1_txresetdone_i;
    assign  gt1_tx_data_vio_sync_in_i[30:29]     =  gt1_txbufstatus_i;
    assign  gt1_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt1_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt1_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt1_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt1_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt1_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt1_rx_data_vio_sync_in_i[31]        =  gt1_rxresetdone_i;
    assign  gt1_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt1_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt1_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt1_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt1_ila_in_i[163:162]                =  gt1_rxclkcorcnt_i;
    assign  gt1_ila_in_i[161]                    =  gt1_rxbyteisaligned_i;
    assign  gt1_ila_in_i[160]                    =  gt1_rxbyterealign_i;
    assign  gt1_ila_in_i[159]                    =  gt1_rxcommadet_i;
    assign  gt1_ila_in_i[158:143]                =  gt1_rxdata_i;
    assign  gt1_ila_in_i[142:140]                =  gt1_rxbufstatus_i;
    assign  gt1_ila_in_i[139]                    =  gt1_rxvalid_i;
    assign  gt1_ila_in_i[138:131]                =  gt1_error_count_i;
    assign  gt1_ila_in_i[130]                    =  gt1_track_data_i;
    assign  gt1_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 2
    assign  gt2_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt2_tx_data_vio_sync_in_i[31]        =  gt2_txresetdone_i;
    assign  gt2_tx_data_vio_sync_in_i[30:29]     =  gt2_txbufstatus_i;
    assign  gt2_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt2_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt2_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt2_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt2_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt2_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt2_rx_data_vio_sync_in_i[31]        =  gt2_rxresetdone_i;
    assign  gt2_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt2_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt2_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt2_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt2_ila_in_i[163:162]                =  gt2_rxclkcorcnt_i;
    assign  gt2_ila_in_i[161]                    =  gt2_rxbyteisaligned_i;
    assign  gt2_ila_in_i[160]                    =  gt2_rxbyterealign_i;
    assign  gt2_ila_in_i[159]                    =  gt2_rxcommadet_i;
    assign  gt2_ila_in_i[158:143]                =  gt2_rxdata_i;
    assign  gt2_ila_in_i[142:140]                =  gt2_rxbufstatus_i;
    assign  gt2_ila_in_i[139]                    =  gt2_rxvalid_i;
    assign  gt2_ila_in_i[138:131]                =  gt2_error_count_i;
    assign  gt2_ila_in_i[130]                    =  gt2_track_data_i;
    assign  gt2_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 3
    assign  gt3_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt3_tx_data_vio_sync_in_i[31]        =  gt3_txresetdone_i;
    assign  gt3_tx_data_vio_sync_in_i[30:29]     =  gt3_txbufstatus_i;
    assign  gt3_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt3_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt3_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt3_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt3_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt3_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt3_rx_data_vio_sync_in_i[31]        =  gt3_rxresetdone_i;
    assign  gt3_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt3_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt3_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt3_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt3_ila_in_i[163:162]                =  gt3_rxclkcorcnt_i;
    assign  gt3_ila_in_i[161]                    =  gt3_rxbyteisaligned_i;
    assign  gt3_ila_in_i[160]                    =  gt3_rxbyterealign_i;
    assign  gt3_ila_in_i[159]                    =  gt3_rxcommadet_i;
    assign  gt3_ila_in_i[158:143]                =  gt3_rxdata_i;
    assign  gt3_ila_in_i[142:140]                =  gt3_rxbufstatus_i;
    assign  gt3_ila_in_i[139]                    =  gt3_rxvalid_i;
    assign  gt3_ila_in_i[138:131]                =  gt3_error_count_i;
    assign  gt3_ila_in_i[130]                    =  gt3_track_data_i;
    assign  gt3_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 4
    assign  gt4_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt4_tx_data_vio_sync_in_i[31]        =  gt4_txresetdone_i;
    assign  gt4_tx_data_vio_sync_in_i[30:29]     =  gt4_txbufstatus_i;
    assign  gt4_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt4_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt4_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt4_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt4_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt4_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt4_rx_data_vio_sync_in_i[31]        =  gt4_rxresetdone_i;
    assign  gt4_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt4_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt4_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt4_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt4_ila_in_i[163:162]                =  gt4_rxclkcorcnt_i;
    assign  gt4_ila_in_i[161]                    =  gt4_rxbyteisaligned_i;
    assign  gt4_ila_in_i[160]                    =  gt4_rxbyterealign_i;
    assign  gt4_ila_in_i[159]                    =  gt4_rxcommadet_i;
    assign  gt4_ila_in_i[158:143]                =  gt4_rxdata_i;
    assign  gt4_ila_in_i[142:140]                =  gt4_rxbufstatus_i;
    assign  gt4_ila_in_i[139]                    =  gt4_rxvalid_i;
    assign  gt4_ila_in_i[138:131]                =  gt4_error_count_i;
    assign  gt4_ila_in_i[130]                    =  gt4_track_data_i;
    assign  gt4_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 5
    assign  gt5_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt5_tx_data_vio_sync_in_i[31]        =  gt5_txresetdone_i;
    assign  gt5_tx_data_vio_sync_in_i[30:29]     =  gt5_txbufstatus_i;
    assign  gt5_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt5_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt5_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt5_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt5_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt5_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt5_rx_data_vio_sync_in_i[31]        =  gt5_rxresetdone_i;
    assign  gt5_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt5_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt5_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt5_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt5_ila_in_i[163:162]                =  gt5_rxclkcorcnt_i;
    assign  gt5_ila_in_i[161]                    =  gt5_rxbyteisaligned_i;
    assign  gt5_ila_in_i[160]                    =  gt5_rxbyterealign_i;
    assign  gt5_ila_in_i[159]                    =  gt5_rxcommadet_i;
    assign  gt5_ila_in_i[158:143]                =  gt5_rxdata_i;
    assign  gt5_ila_in_i[142:140]                =  gt5_rxbufstatus_i;
    assign  gt5_ila_in_i[139]                    =  gt5_rxvalid_i;
    assign  gt5_ila_in_i[138:131]                =  gt5_error_count_i;
    assign  gt5_ila_in_i[130]                    =  gt5_track_data_i;
    assign  gt5_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 6
    assign  gt6_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt6_tx_data_vio_sync_in_i[31]        =  gt6_txresetdone_i;
    assign  gt6_tx_data_vio_sync_in_i[30:29]     =  gt6_txbufstatus_i;
    assign  gt6_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt6_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt6_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt6_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt6_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt6_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt6_rx_data_vio_sync_in_i[31]        =  gt6_rxresetdone_i;
    assign  gt6_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt6_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt6_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt6_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt6_ila_in_i[163:162]                =  gt6_rxclkcorcnt_i;
    assign  gt6_ila_in_i[161]                    =  gt6_rxbyteisaligned_i;
    assign  gt6_ila_in_i[160]                    =  gt6_rxbyterealign_i;
    assign  gt6_ila_in_i[159]                    =  gt6_rxcommadet_i;
    assign  gt6_ila_in_i[158:143]                =  gt6_rxdata_i;
    assign  gt6_ila_in_i[142:140]                =  gt6_rxbufstatus_i;
    assign  gt6_ila_in_i[139]                    =  gt6_rxvalid_i;
    assign  gt6_ila_in_i[138:131]                =  gt6_error_count_i;
    assign  gt6_ila_in_i[130]                    =  gt6_track_data_i;
    assign  gt6_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

    // Chipscope connections on GT 7
    assign  gt7_tx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt7_tx_data_vio_sync_in_i[31]        =  gt7_txresetdone_i;
    assign  gt7_tx_data_vio_sync_in_i[30:29]     =  gt7_txbufstatus_i;
    assign  gt7_tx_data_vio_sync_in_i[28:0]      =  29'b00000000000000000000000000000;
    assign  gt7_loopback_i                       =  tx_data_vio_async_out_i[31:29];
    assign  gt7_txprecursorinv_i                 =  tx_data_vio_async_out_i[28];
    assign  gt7_txuserrdy_i                      =  tx_data_vio_sync_out_i[31];
    assign  gt7_txpd_i                           =  tx_data_vio_sync_out_i[30:29];
    assign  gt7_rx_data_vio_async_in_i[31:0]     =  32'b00000000000000000000000000000000;
    assign  gt7_rx_data_vio_sync_in_i[31]        =  gt7_rxresetdone_i;
    assign  gt7_rx_data_vio_sync_in_i[30:0]      =  31'b0000000000000000000000000000000;
    assign  gt7_rxuserrdy_i                      =  rx_data_vio_async_out_i[31];
    assign  gt7_rxpd_i                           =  rx_data_vio_async_out_i[30:29];
    assign  gt7_rxbufreset_i                     =  rx_data_vio_async_out_i[28];
    assign  gt7_ila_in_i[163:162]                =  gt7_rxclkcorcnt_i;
    assign  gt7_ila_in_i[161]                    =  gt7_rxbyteisaligned_i;
    assign  gt7_ila_in_i[160]                    =  gt7_rxbyterealign_i;
    assign  gt7_ila_in_i[159]                    =  gt7_rxcommadet_i;
    assign  gt7_ila_in_i[158:143]                =  gt7_rxdata_i;
    assign  gt7_ila_in_i[142:140]                =  gt7_rxbufstatus_i;
    assign  gt7_ila_in_i[139]                    =  gt7_rxvalid_i;
    assign  gt7_ila_in_i[138:131]                =  gt7_error_count_i;
    assign  gt7_ila_in_i[130]                    =  gt7_track_data_i;
    assign  gt7_ila_in_i[129:0]                  =  130'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;


    assign  tx_data_vio_async_in_i =    (mux_sel_i == 3'b000)?gt0_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b001)?gt1_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b010)?gt2_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b011)?gt3_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b100)?gt4_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b101)?gt5_tx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b110)?gt6_tx_data_vio_async_in_i:
                                                              gt7_tx_data_vio_async_in_i;

    assign  tx_data_vio_sync_in_i =     (mux_sel_i == 3'b000)?gt0_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b001)?gt1_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b010)?gt2_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b011)?gt3_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b100)?gt4_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b101)?gt5_tx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b110)?gt6_tx_data_vio_sync_in_i:
                                                              gt7_tx_data_vio_sync_in_i;


    assign  rx_data_vio_async_in_i =    (mux_sel_i == 3'b000)?gt0_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b001)?gt1_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b010)?gt2_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b011)?gt3_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b100)?gt4_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b101)?gt5_rx_data_vio_async_in_i:
                                        (mux_sel_i == 3'b110)?gt6_rx_data_vio_async_in_i:
                                                              gt7_rx_data_vio_async_in_i;

    assign  rx_data_vio_sync_in_i =     (mux_sel_i == 3'b000)?gt0_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b001)?gt1_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b010)?gt2_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b011)?gt3_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b100)?gt4_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b101)?gt5_rx_data_vio_sync_in_i:
                                        (mux_sel_i == 3'b110)?gt6_rx_data_vio_sync_in_i:
                                                              gt7_rx_data_vio_sync_in_i;

    assign  ila_in_i =                  (mux_sel_i == 3'b000)?gt0_ila_in_i:
                                        (mux_sel_i == 3'b001)?gt1_ila_in_i:
                                        (mux_sel_i == 3'b010)?gt2_ila_in_i:
                                        (mux_sel_i == 3'b011)?gt3_ila_in_i:
                                        (mux_sel_i == 3'b100)?gt4_ila_in_i:
                                        (mux_sel_i == 3'b101)?gt5_ila_in_i:
                                        (mux_sel_i == 3'b110)?gt6_ila_in_i:
                                                              gt7_ila_in_i;

    
 
end //end EXAMPLE_USE_CHIPSCOPE=1 generate section
else 
begin: no_chipscope 

    // If Chipscope is not being used, drive GT reset signal
    // from the top level ports

    //***********************************************************************//
    //                                                                       //
    //---------------------  Reset Logic  -----------------------------------//
    //                                                                       //
    //***********************************************************************//
// The Example design supports Sequence Mode; hence PCS and PMA resets 
// are tied to ground. In Single mode, the user needs to follow the
// reset sequencing given in the user guide.

      assign gt0_rxuserrdy_i = gt0_rxuserrdy_r;
      assign gt0_txuserrdy_i = gt0_txuserrdy_r;
      assign gt1_rxuserrdy_i = gt1_rxuserrdy_r;
      assign gt1_txuserrdy_i = gt1_txuserrdy_r;
      assign gt2_rxuserrdy_i = gt2_rxuserrdy_r;
      assign gt2_txuserrdy_i = gt2_txuserrdy_r;
      assign gt3_rxuserrdy_i = gt3_rxuserrdy_r;
      assign gt3_txuserrdy_i = gt3_txuserrdy_r;
      assign gt4_rxuserrdy_i = gt4_rxuserrdy_r;
      assign gt4_txuserrdy_i = gt4_txuserrdy_r;
      assign gt5_rxuserrdy_i = gt5_rxuserrdy_r;
      assign gt5_txuserrdy_i = gt5_txuserrdy_r;
      assign gt6_rxuserrdy_i = gt6_rxuserrdy_r;
      assign gt6_txuserrdy_i = gt6_txuserrdy_r;
      assign gt7_rxuserrdy_i = gt7_rxuserrdy_r;
      assign gt7_txuserrdy_i = gt7_txuserrdy_r;

      always @(posedge gt0_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt0_rxuserrdy_r <= `DLY 1'b0;
         else
           gt0_rxuserrdy_r <= `DLY gt0_cplllock_i;
      end
      always @(posedge gt0_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt0_txuserrdy_r <= `DLY 1'b0;
         else
           gt0_txuserrdy_r <= `DLY gt0_cplllock_i;
      end
      always @(posedge gt0_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt1_rxuserrdy_r <= `DLY 1'b0;
         else
           gt1_rxuserrdy_r <= `DLY gt1_cplllock_i;
      end
      always @(posedge gt0_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt1_txuserrdy_r <= `DLY 1'b0;
         else
           gt1_txuserrdy_r <= `DLY gt1_cplllock_i;
      end
      always @(posedge gt2_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt2_rxuserrdy_r <= `DLY 1'b0;
         else
           gt2_rxuserrdy_r <= `DLY gt2_cplllock_i;
      end
      always @(posedge gt2_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt2_txuserrdy_r <= `DLY 1'b0;
         else
           gt2_txuserrdy_r <= `DLY gt2_cplllock_i;
      end
      always @(posedge gt2_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt3_rxuserrdy_r <= `DLY 1'b0;
         else
           gt3_rxuserrdy_r <= `DLY gt3_cplllock_i;
      end
      always @(posedge gt2_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt3_txuserrdy_r <= `DLY 1'b0;
         else
           gt3_txuserrdy_r <= `DLY gt3_cplllock_i;
      end
      always @(posedge gt4_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt4_rxuserrdy_r <= `DLY 1'b0;
         else
           gt4_rxuserrdy_r <= `DLY gt4_cplllock_i;
      end
      always @(posedge gt4_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt4_txuserrdy_r <= `DLY 1'b0;
         else
           gt4_txuserrdy_r <= `DLY gt4_cplllock_i;
      end
      always @(posedge gt4_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt5_rxuserrdy_r <= `DLY 1'b0;
         else
           gt5_rxuserrdy_r <= `DLY gt5_cplllock_i;
      end
      always @(posedge gt4_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt5_txuserrdy_r <= `DLY 1'b0;
         else
           gt5_txuserrdy_r <= `DLY gt5_cplllock_i;
      end
      always @(posedge gt6_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt6_rxuserrdy_r <= `DLY 1'b0;
         else
           gt6_rxuserrdy_r <= `DLY gt6_cplllock_i;
      end
      always @(posedge gt6_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt6_txuserrdy_r <= `DLY 1'b0;
         else
           gt6_txuserrdy_r <= `DLY gt6_cplllock_i;
      end
      always @(posedge gt6_txusrclk_i or posedge GTRXRESET_IN)
      begin
         if(GTRXRESET_IN)
           gt7_rxuserrdy_r <= `DLY 1'b0;
         else
           gt7_rxuserrdy_r <= `DLY gt7_cplllock_i;
      end
      always @(posedge gt6_txusrclk_i or posedge GTTXRESET_IN)
      begin
         if(GTTXRESET_IN)
           gt7_txuserrdy_r <= `DLY 1'b0;
         else
           gt7_txuserrdy_r <= `DLY gt7_cplllock_i;
      end

    	assign  gt0_gtrxreset_i = GTRXRESET_IN || !gt0_cplllock_i;
    	assign  gt0_gttxreset_i = GTTXRESET_IN || !gt0_cplllock_i;
    	assign  gt0_cpllreset_i = GTTXRESET_IN;

    	assign  gt1_gtrxreset_i = GTRXRESET_IN || !gt1_cplllock_i;
    	assign  gt1_gttxreset_i = GTTXRESET_IN || !gt1_cplllock_i;
    	assign  gt1_cpllreset_i = GTTXRESET_IN;

    	assign  gt2_gtrxreset_i = GTRXRESET_IN || !gt2_cplllock_i;
    	assign  gt2_gttxreset_i = GTTXRESET_IN || !gt2_cplllock_i;
    	assign  gt2_cpllreset_i = GTTXRESET_IN;

    	assign  gt3_gtrxreset_i = GTRXRESET_IN || !gt3_cplllock_i;
    	assign  gt3_gttxreset_i = GTTXRESET_IN || !gt3_cplllock_i;
    	assign  gt3_cpllreset_i = GTTXRESET_IN;

    	assign  gt4_gtrxreset_i = GTRXRESET_IN || !gt4_cplllock_i;
    	assign  gt4_gttxreset_i = GTTXRESET_IN || !gt4_cplllock_i;
    	assign  gt4_cpllreset_i = GTTXRESET_IN;

    	assign  gt5_gtrxreset_i = GTRXRESET_IN || !gt5_cplllock_i;
    	assign  gt5_gttxreset_i = GTTXRESET_IN || !gt5_cplllock_i;
    	assign  gt5_cpllreset_i = GTTXRESET_IN;

    	assign  gt6_gtrxreset_i = GTRXRESET_IN || !gt6_cplllock_i;
    	assign  gt6_gttxreset_i = GTTXRESET_IN || !gt6_cplllock_i;
    	assign  gt6_cpllreset_i = GTTXRESET_IN;

    	assign  gt7_gtrxreset_i = GTRXRESET_IN || !gt7_cplllock_i;
    	assign  gt7_gttxreset_i = GTTXRESET_IN || !gt7_cplllock_i;
    	assign  gt7_cpllreset_i = GTTXRESET_IN;




    assign  gt0_rxpcsreset_i = tied_to_ground_i;
    assign  gt0_txpcsreset_i = tied_to_ground_i;
    assign  gt1_rxpcsreset_i = tied_to_ground_i;
    assign  gt1_txpcsreset_i = tied_to_ground_i;
    assign  gt2_rxpcsreset_i = tied_to_ground_i;
    assign  gt2_txpcsreset_i = tied_to_ground_i;
    assign  gt3_rxpcsreset_i = tied_to_ground_i;
    assign  gt3_txpcsreset_i = tied_to_ground_i;
    assign  gt4_rxpcsreset_i = tied_to_ground_i;
    assign  gt4_txpcsreset_i = tied_to_ground_i;
    assign  gt5_rxpcsreset_i = tied_to_ground_i;
    assign  gt5_txpcsreset_i = tied_to_ground_i;
    assign  gt6_rxpcsreset_i = tied_to_ground_i;
    assign  gt6_txpcsreset_i = tied_to_ground_i;
    assign  gt7_rxpcsreset_i = tied_to_ground_i;
    assign  gt7_txpcsreset_i = tied_to_ground_i;


    // assign resets for frame_gen modules
    assign  gt0_tx_system_reset_c = !gt0_txresetdone_r2;
    assign  gt1_tx_system_reset_c = !gt1_txresetdone_r2;
    assign  gt2_tx_system_reset_c = !gt2_txresetdone_r2;
    assign  gt3_tx_system_reset_c = !gt3_txresetdone_r2;
    assign  gt4_tx_system_reset_c = !gt4_txresetdone_r2;
    assign  gt5_tx_system_reset_c = !gt5_txresetdone_r2;
    assign  gt6_tx_system_reset_c = !gt6_txresetdone_r2;
    assign  gt7_tx_system_reset_c = !gt7_txresetdone_r2;

    // assign resets for frame_check modules
    assign  gt0_rx_system_reset_c = !gt0_rxresetdone_r3;
    assign  gt1_rx_system_reset_c = !gt1_rxresetdone_r3;
    assign  gt2_rx_system_reset_c = !gt2_rxresetdone_r3;
    assign  gt3_rx_system_reset_c = !gt3_rxresetdone_r3;
    assign  gt4_rx_system_reset_c = !gt4_rxresetdone_r3;
    assign  gt5_rx_system_reset_c = !gt5_rxresetdone_r3;
    assign  gt6_rx_system_reset_c = !gt6_rxresetdone_r3;
    assign  gt7_rx_system_reset_c = !gt7_rxresetdone_r3;

//-------------------------------------------------------------
    assign  gttxreset_i                          =  tied_to_ground_i;
    assign  gtrxreset_i                          =  tied_to_ground_i;
    assign  user_tx_reset_i                      =  tied_to_ground_i;
    assign  user_rx_reset_i                      =  tied_to_ground_i;
    assign  mux_sel_i                            =  tied_to_ground_vec_i[2:0];
    assign  gt0_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt0_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt0_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt0_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt0_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt1_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt1_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt1_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt1_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt1_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt2_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt2_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt2_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt2_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt2_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt3_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt3_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt3_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt3_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt3_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt4_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt4_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt4_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt4_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt4_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt5_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt5_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt5_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt5_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt5_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt6_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt6_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt6_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt6_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt6_rxbufreset_i                     =  tied_to_ground_i;
    assign  gt7_loopback_i                       =  tied_to_ground_vec_i[2:0];
    assign  gt7_txprecursorinv_i                 =  tied_to_ground_i;
    assign  gt7_txpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt7_rxpd_i                           =  tied_to_ground_vec_i[1:0];
    assign  gt7_rxbufreset_i                     =  tied_to_ground_i;

end
endgenerate //End generate for EXAMPLE_USE_CHIPSCOPE

endmodule
    
//-------------------------------------------------------------------
//
//  VIO core module declaration
//
//-------------------------------------------------------------------
module data_vio
  (
    control,
    clk,
    async_in,
    async_out,
    sync_in,
    sync_out
  );
  inout  [35:0] control;
  input         clk;
  input  [31:0] async_in;
  output [31:0] async_out;
  input  [31:0] sync_in;
  output [31:0] sync_out;
endmodule


//-------------------------------------------------------------------
//
//  ICON core module declaration
//
//-------------------------------------------------------------------
module icon
  (
      control0,
      control1,
      control2,
      control3
  );
  inout [35:0] control0;
  inout [35:0] control1;
  inout [35:0] control2;
  inout [35:0] control3;
endmodule


//-------------------------------------------------------------------
//
//  ILA core module declaration
//  This is used to allow RX signals to be monitored
//
//-------------------------------------------------------------------
module ila
  (
    control,
    clk,
    trig0
  );
  inout [35:0]  control;
  input         clk    ;
  input [163:0] trig0  ;
endmodule


