-- ODDR: Output Double Data Rate Output Register with Set, Reset
--       and Clock Enable. 
--       Virtex-5
-- Xilinx HDL Libraries Guide, version 14.5

ODDR_inst : ODDR
generic map(
   DDR_CLK_EDGE => "OPPOSITE_EDGE", -- "OPPOSITE_EDGE" or "SAME_EDGE" 
   INIT => '0',   -- Initial value for Q port ('1' or '0')
   SRTYPE => "SYNC") -- Reset Type ("ASYNC" or "SYNC")
port map (
   Q => Q,   -- 1-bit DDR output
   C => C,    -- 1-bit clock input
   CE => CE,  -- 1-bit clock enable input
   D1 => D1,  -- 1-bit data input (positive edge)
   D2 => D2,  -- 1-bit data input (negative edge)
   R => R,    -- 1-bit reset input
   S => S     -- 1-bit set input
);
  
-- End of ODDR_inst instantiation
