// FIFO_SYNC_MACRO: Synchronous First-In, First-Out (FIFO) RAM Buffer
//                  Virtex-5
// Xilinx HDL Libraries Guide, version 14.5

/////////////////////////////////////////////////////////////////
// DATA_WIDTH | FIFO_SIZE | FIFO Depth | RDCOUNT/WRCOUNT Width //
// ===========|===========|============|=======================//
//   37-72    |  "36Kb"   |     512    |         9-bit         //
//   19-36    |  "36Kb"   |    1024    |        10-bit         //
//   19-36    |  "18Kb"   |     512    |         9-bit         //
//   10-18    |  "36Kb"   |    2048    |        11-bit         //
//   10-18    |  "18Kb"   |    1024    |        10-bit         //
//    5-9     |  "36Kb"   |    4096    |        12-bit         //
//    5-9     |  "18Kb"   |    2048    |        11-bit         //
//    1-4     |  "36Kb"   |    8192    |        13-bit         //
//    1-4     |  "18Kb"   |    4096    |        12-bit         //
/////////////////////////////////////////////////////////////////

FIFO_SYNC_MACRO  #(
   .DEVICE("VIRTEX5"), // Target device: "VIRTEX5", "VIRTEX6"
   .ALMOST_EMPTY_OFFSET(9'h080), // Sets the almost empty threshold
   .ALMOST_FULL_OFFSET(9'h080),  // Sets almost full threshold
   .DATA_WIDTH(0), // Valid values are 1-72 (37-72 only valid when FIFO_SIZE="36Kb")
   .DO_REG(0),     // Optional output register (0 or 1)
   .FIFO_SIZE ("18Kb"), // Target BRAM: "18Kb" or "36Kb"
   .SIM_MODE("SAFE") // Simulation: "SAFE" vs. "FAST", see "Synthesis and Simulation Design Guide" for details
) FIFO_SYNC_MACRO_inst (
   .ALMOSTEMPTY(ALMOSTEMPTY), // Output almost empty
   .ALMOSTFULL(ALMOSTFULL),   // Output almost full
   .DO(DO),                   // Output data
   .EMPTY(EMPTY),             // Output empty
   .FULL(FULL),               // Output full
   .RDCOUNT(RDCOUNT),         // Output read count
   .RDERR(RDERR),             // Output read error
   .WRCOUNT(WRCOUNT),         // Output write count
   .WRERR(WRERR),             // Output write error
   .CLK(CLK),                 // Input clock
   .DI(DI),                   // Input data
   .RDEN(RDEN),               // Input read enable
   .RST(RST),                 // Input reset
   .WREN(WREN)                // Input write enable
);

// End of FIFO_SYNC_MACRO_inst instantiation
