//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2009 Xilinx, Inc.
// This design is confidential and proprietary of Xilinx, Inc.
// All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /   Vendor: Xilinx
// \   \   \/    Version: 11.2
//  \   \        Application: Partial Reconfiguration
//  /   /        Filename: dvi_if.v
// /___/   /\    Date Last Modified: 11 July 2009
// \   \  /  \   
//  \___\/\___\
// Device: Virtex-5
// Design Name: Color2
// Purpose: Partial Reconfiguration User Guide
///////////////////////////////////////////////////////////////////////////////
// 
// Description:    
//      This module takes as input, the DVI input signals and registers them.
//  Therefore all signals going to the DVI hardware is registered in the 
//      IOBs.
//
// Design Notes:
//      Wrapper type file to register all the inputs to the DVI hardware.
//   
//-----------------------------------------------------------------------------
// Structure:   
//              -- dvi_if.v
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
// Module Declaration
///////////////////////////////////////////////////////////////////////////////
`timescale 1 ns / 100 ps
module dvi_if(
        clk,                    // I
        rst,                    // I
        HSYNC,                  // I
        VSYNC,                  // I
        DE,                     // I
        R0,                     // I
        R1,                     // I
        R2,                     // I
        R3,                     // I
        R4,                     // I
        R5,                     // I
        R6,                     // I
        R7,                     // I
        G0,                     // I
        G1,                     // I                                    
        G2,                     // I
        G3,                     // I
        G4,                     // I
        G5,                     // I
        G6,                     // I
        G7,                     // I
        B0,                     // I
        B1,                     // I
        B2,                     // I
        B3,                     // I
        B4,                     // I    
        B5,                     // I
        B6,                     // I
        B7,                     // I
        DVI_LCD_HSYNC,          // O
        DVI_LCD_VSYNC,          // O
        DVI_LCD_DE,             // O
        DVI_LCD_CLK_P,          // O
        DVI_LCD_CLK_N,          // O
        DVI_LCD_DATA0,          // O
        DVI_LCD_DATA1,          // O
        DVI_LCD_DATA2,          // O
        DVI_LCD_DATA3,          // O
        DVI_LCD_DATA4,          // O
        DVI_LCD_DATA5,          // O
        DVI_LCD_DATA6,          // O
        DVI_LCD_DATA7,          // O
        DVI_LCD_DATA8,          // O
        DVI_LCD_DATA9,          // O
        DVI_LCD_DATA10,         // O
        DVI_LCD_DATA11          // O
);

///////////////////////////////////////////////////////////////////////////////
// Port Declarations
///////////////////////////////////////////////////////////////////////////////
        input                   clk;
        input                   rst;
        input                   HSYNC;                          
        input                   VSYNC;                          
        input                   DE;     
        input                   R0;
        input                   R1;
        input                   R2;
        input                   R3;
        input                   R4;
        input                   R5;
        input                   R6;
        input                   R7;
        input                   G0;
        input                   G1;                             
        input                   G2;
        input                   G3;
        input                   G4;
        input                   G5;
        input                   G6;
        input                   G7;
        input                   B0;
        input                   B1;
        input                   B2;
        input                   B3;
        input                   B4;
        input                   B5;
        input                   B6;
        input                   B7;
        output                  DVI_LCD_HSYNC;
        output                  DVI_LCD_VSYNC;
        output                  DVI_LCD_DE;
        output                  DVI_LCD_CLK_P;
        output                  DVI_LCD_CLK_N;
        output                  DVI_LCD_DATA0;
        output                  DVI_LCD_DATA1;
        output                  DVI_LCD_DATA2;
        output                  DVI_LCD_DATA3;
        output                  DVI_LCD_DATA4;
        output                  DVI_LCD_DATA5;
        output                  DVI_LCD_DATA6;
        output                  DVI_LCD_DATA7;
        output                  DVI_LCD_DATA8;
        output                  DVI_LCD_DATA9;
        output                  DVI_LCD_DATA10;
        output                  DVI_LCD_DATA11;

///////////////////////////////////////////////////////////////////////////////
// Signal Declaration
///////////////////////////////////////////////////////////////////////////////
        wire                   clk;
        wire                   rst;
        wire                   HSYNC;                          
        wire                   VSYNC;                          
        wire                   DE;     
        wire                   R0;
        wire                   R1;
        wire                   R2;
        wire                   R3;
        wire                   R4;
        wire                   R5;
        wire                   R6;
        wire                   R7;
        wire                   G0;
        wire                   G1;                             
        wire                   G2;
        wire                   G3;
        wire                   G4;
        wire                   G5;
        wire                   G6;
        wire                   G7;
        wire                   B0;
        wire                   B1;
        wire                   B2;
        wire                   B3;
        wire                   B4;
        wire                   B5;
        wire                   B6;
        wire                   B7;
        wire                  DVI_LCD_HSYNC;
        wire                  DVI_LCD_VSYNC;
        wire                  DVI_LCD_DE;
        wire                  DVI_LCD_CLK_P;
        wire                  DVI_LCD_CLK_N;
        wire                  DVI_LCD_DATA0;
        wire                  DVI_LCD_DATA1;
        wire                  DVI_LCD_DATA2;
        wire                  DVI_LCD_DATA3;
        wire                  DVI_LCD_DATA4;
        wire                  DVI_LCD_DATA5;
        wire                  DVI_LCD_DATA6;
        wire                  DVI_LCD_DATA7;
        wire                  DVI_LCD_DATA8;
        wire                  DVI_LCD_DATA9;
        wire                  DVI_LCD_DATA10;
        wire                  DVI_LCD_DATA11;                
        ////////////////////////////////////////////////////////////////////////////
        // FDRE COMPONENT INSTANTIATION FOR IOB OUTPUT REGISTERS
        // -- All output to DVI/dvi are registered
        ////////////////////////////////////////////////////////////////////////////
	// Added inversion on rst for DVI_LCD_HSYNC, DVI_LCD_VSYNC,
	// DVI_LCD_DE
       
 
        ODDR FDRSE_HSYNC (.Q(DVI_LCD_HSYNC), .C(clk), .CE(1'b1), .R(1'b0), .S(1'b0), .D1(HSYNC), .D2(HSYNC))     ; 
        ODDR FDRSE_VSYNC (.Q(DVI_LCD_VSYNC), .C(clk), .CE(1'b1), .R(1'b0), .S(1'b0), .D1(VSYNC), .D2(VSYNC))     ;
        ODDR FDRSE_DE    (.Q(DVI_LCD_DE),    .C(clk), .CE(1'b1), .R(1'b0), .S(1'b0), .D1(DE), .D2(DE))    ;
        
	ODDR DVI_CLKP_ODDR (.Q(DVI_LCD_CLK_P), .C(clk), .CE(1'b1), .R(1'b0), .D1(1'b1), .D2(1'b0), .S(1'b0));
        ODDR DVI_CLKN_ODDR (.Q(DVI_LCD_CLK_N), .C(clk), .CE(1'b1), .R(1'b0), .D1(1'b0), .D2(1'b1), .S(1'b0));

        ODDR ODDR_DVI_DATA0   (.Q(DVI_LCD_DATA0),  .C(clk), .CE(1'b1), .R(~DE), .D2(R6),   .D1(G2),     .S(1'b0));
        ODDR ODDR_DVI_DATA1   (.Q(DVI_LCD_DATA1),  .C(clk), .CE(1'b1), .R(~DE), .D2(R7),   .D1(G3),     .S(1'b0));
        ODDR ODDR_DVI_DATA2   (.Q(DVI_LCD_DATA2),  .C(clk), .CE(1'b1), .R(~DE), .D2(B0),   .D1(G4),     .S(1'b0));
        ODDR ODDR_DVI_DATA3   (.Q(DVI_LCD_DATA3),  .C(clk), .CE(1'b1), .R(~DE), .D2(B1),   .D1(G5),     .S(1'b0));
        ODDR ODDR_DVI_DATA4   (.Q(DVI_LCD_DATA4),  .C(clk), .CE(1'b1), .R(~DE), .D2(B2),   .D1(G6),     .S(1'b0));
        ODDR ODDR_DVI_DATA5   (.Q(DVI_LCD_DATA5),  .C(clk), .CE(1'b1), .R(~DE), .D2(B3),   .D1(G7),     .S(1'b0));
        ODDR ODDR_DVI_DATA6   (.Q(DVI_LCD_DATA6),  .C(clk), .CE(1'b1), .R(~DE), .D2(B4),   .D1(R0),     .S(1'b0));
        ODDR ODDR_DVI_DATA7   (.Q(DVI_LCD_DATA7),  .C(clk), .CE(1'b1), .R(~DE), .D2(B5),   .D1(R1),     .S(1'b0));
        ODDR ODDR_DVI_DATA8   (.Q(DVI_LCD_DATA8),  .C(clk), .CE(1'b1), .R(~DE), .D2(B6),   .D1(R2),     .S(1'b0));
        ODDR ODDR_DVI_DATA9   (.Q(DVI_LCD_DATA9),  .C(clk), .CE(1'b1), .R(~DE), .D2(B7),   .D1(R3),     .S(1'b0));
        ODDR ODDR_DVI_DATA10  (.Q(DVI_LCD_DATA10), .C(clk), .CE(1'b1), .R(~DE), .D2(G0),   .D1(R4),     .S(1'b0));
        ODDR ODDR_DVI_DATA11  (.Q(DVI_LCD_DATA11), .C(clk), .CE(1'b1), .R(~DE), .D2(G1),   .D1(R5),     .S(1'b0));


endmodule
