-- EQ_COMPARE_MACRO: Equality Comparator implemented in a DSP48E
--                   7 Series
-- Xilinx HDL Libraries Guide, version 14.6

EQ_COMPARE_MACRO_inst : EQ_COMPARE_MACRO
generic map (
   DEVICE => "7SERIES",         -- Target Device: "VIRTEX5", "7SERIES"
   LATENCY => 2,                -- Desired clock cycle latency, 0-2
   MASK => X"000000000000",     -- Select bits to be masked, must set 
                                -- SEL_MASK = "MASK"
   SEL_MASK => "MASK",          -- "MASK" = use MASK generic,
                                -- "DYNAMIC_PATTERN = use DYNAMIC_PATTERN input bus
   SEL_PATTERN => "DYNAMIC_PATTERN", -- "DYNAMIC_PATTERN" = use DYNAMIC_PATTERN input bus
                                     -- "STATIC_PATTERN" = use STATIC_PATTERN generic
   STATIC_PATTERN => X"000000000000", -- Specify static pattern, 
                                      -- must set SEL_PATTERN = "STATIC_PATTERN
   WIDTH => 48)            -- Comparator output bus width, 1-48
port map (
   Q => Q,        -- 1-bit output indicating a match 
   CE => CE,      -- 1-bit active high input clock enable input
   CLK => CLK,    -- 1-bit positive edge clock input
   DATA_IN => DATA_IN, -- Input Data Bus, width determined by WIDTH generic
   DYNAMIC_PATTERN, => DYNAMIC_PATTERN, -- Input Dynamic Match/Mask Bus, width determined by WIDTH generic
   RST => RST       -- 1-bit input active high reset
);
-- End of EQ_COMPARE_MACRO_inst instantiation
