-- IBUFDS_INTERMDISABLE: Differential Input Buffer with Input Termination Disable
--                       May only be placed in High Range (HR) Banks
--                       7 Series
-- Xilinx HDL Libraries Guide, version 14.6

IBUFDS_INTERMDISABLE_inst : IBUFDS_INTERMDISABLE
generic map (
   DIFF_TERM => "FALSE", -- Differential Termination 
   IBUF_LOW_PWR => "TRUE", -- Low power (TRUE) vs. performance (FALSE) setting for referenced I/O standards
   IOSTANDARD => "DEFAULT" -- Specify the input I/O standard
   USE_IBUFDISABLE => "TRUE") -- Set to "TRUE" to enable IBUFDISABLE feature
port map (
   O => O,  -- Buffer output
   I => I,  -- Diff_p buffer input (connect directly to top-level port)
   IB => IB, -- Diff_n buffer input (connect directly to top-level port)
   IBUFDISABLE => IBUFDISABLE, -- Buffer disable input, low=disable
   INTERMDISALE => INTERMDISABLE -- Input termination disable
);

-- End of IBUFDS_IBUFDISABLE_inst instantiation
