// EQ_COMPARE_MACRO: Equality Comparator implemented in a DSP48E
//                   7 Series
// Xilinx HDL Libraries Guide, version 14.6

EQ_COMPARE_MACRO #(
   .DEVICE("7SERIES"),       // Target Device: "VIRTEX5", "VIRTEX6","7SERIES"
   .LATENCY(2),              // Desired clock cycle latency, 0-2
   .MASK(48'h000000000000),  // Select bits to be masked, must set SEL_MASK="MASK"
   .SEL_MASK("MASK"),        // "MASK" = use MASK parameter,
                             //   "DYNAMIC_PATTERN" = use DYNAMIC_PATTERN input bus
   .SEL_PATTERN("STATIC_PATTERN"), // "STATIC_PATTERN" = use STATIC_PATTERN parameter,
                                   //   "DYNAMIC_PATTERN = use DYNAMIC_PATTERN input bus
   .STATIC_PATTERN(48'h000000000000), // Specify static pattern, must set SEL_PATTERN = "STATIC_PATTERN"
   .WIDTH(48)                // Comparator output bus width, 1-48
) EQ_COMPARE_MACRO_inst (
   .Q(Q),     // 1-bit output indicating a match
   .CE(CE),   // 1-bit active high input clock enable
   .CLK(CLK), // 1-bit positive edge clock input
   .DATA_IN(DATA_IN), // Input Data Bus, width determined by WIDTH parameter 
   .DYNAMIC_PATTERN(DYNAMIC_PATTERN), // Input Dynamic Match/Mask Bus, width determined by WIDTH parameter 
   .RST(RST)  // 1-bit input active high reset
);

// End of EQ_COMPARE_MACRO_inst instantiation
