// IOBUF_DCIEN: Single-ended Bi-directional Buffer with Digital Controlled Impedance (DCI)
//              and Input path enable/disable
//              May only be placed in High Performance (HP) Banks
//              7 Series
// Xilinx HDL Libraries Guide, version 14.6

IOBUF_DCIEN #(
   .DRIVE(12), // Specify the output drive strength
   .IBUF_LOW_PWR("TRUE"),  // Low Power - "TRUE", High Performance = "FALSE"
   .IOSTANDARD("DEFAULT"), // Specify the I/O standard
   .SLEW("SLOW"),          // Specify the output slew rate
   .USE_IBUFDISABLE("TRUE") // Use IBUFDISABLE function, "TRUE" or "FALSE"
) IOBUF_DCIEN_inst (
   .O(O),     // Buffer output
   .IO(IO),   // Buffer inout port (connect directly to top-level port)
   .DCITERMDISABLE(DCITERMDISABLE), // DCI Termination enable input
   .I(I),     // Buffer input
   .IBUFDISABLE(IBUFDISABLE), // Input disable input, low=disable
   .T(T)      // 3-state enable input, high=input, low=output
);
  
// End of IOBUF_DCIEN_inst instantiation
